/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.terraform.api;

import com.deliveredtechnologies.io.Executable;
import com.deliveredtechnologies.terraform.TerraformCommand;
import com.deliveredtechnologies.terraform.TerraformCommandLineDecorator;
import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.api.TerraformCliOperation;
import com.deliveredtechnologies.terraform.api.TerraformOption;
import java.io.IOException;
import org.slf4j.Logger;

public class TerraformApply
extends TerraformCliOperation {
    TerraformApply(Executable terraform, Logger logger) {
        super(terraform, logger);
    }

    TerraformApply(Executable terraform) {
        super(terraform);
    }

    public TerraformApply() throws IOException {
        this(new TerraformCommandLineDecorator(TerraformCommand.APPLY));
    }

    public TerraformApply(Logger logger) throws IOException {
        this(new TerraformCommandLineDecorator(TerraformCommand.APPLY, logger));
    }

    public TerraformApply(String tfRootDir) throws IOException, TerraformException {
        this(new TerraformCommandLineDecorator(TerraformCommand.APPLY, tfRootDir));
    }

    public TerraformApply(String tfRootDir, Logger logger) throws IOException, TerraformException {
        this(new TerraformCommandLineDecorator(TerraformCommand.APPLY, tfRootDir), logger);
    }

    @Override
    public TerraformOption[] getTerraformParams() {
        return Option.values();
    }

    public static enum Option implements TerraformOption
    {
        tfVars("-var"),
        tfVarFiles("-var-file"),
        lockTimeout("-lock-timeout="),
        target("-target="),
        noColor("-no-color"),
        refreshState("-refresh="),
        autoApprove("-auto-approve", "true"),
        plan("%s");

        public String format;
        public String defaultValue;

        private Option(String format) {
            this.format = format;
        }

        private Option(String format, String defaultValue) {
            this.format = format;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }

        @Override
        public String getFormat() {
            return this.format;
        }
    }
}

