/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.terraform.api;

import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.TerraformUtils;
import com.deliveredtechnologies.terraform.api.TerraformOperation;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class TerraformClean
implements TerraformOperation<String> {
    private Path tfRootModulePath;
    private Path tfModulesPath;

    public TerraformClean(String tfModules, String tfRootModule) throws IOException, TerraformException {
        this.tfModulesPath = StringUtils.isEmpty((CharSequence)tfModules) ? TerraformUtils.getDefaultTfModulesDir() : Paths.get(tfModules, new String[0]);
        this.tfRootModulePath = StringUtils.isEmpty((CharSequence)tfRootModule) ? TerraformUtils.getDefaultTerraformRootModuleDir() : TerraformUtils.getTerraformRootModuleDir(tfRootModule);
    }

    @Override
    public String execute(Properties properties) throws TerraformException {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        try {
            if (!this.tfRootModulePath.toFile().exists()) {
                throw new IOException(this.tfRootModulePath.toString() + " does not exist!");
            }
            StringBuilder response = new StringBuilder("Deleting...\n");
            if (this.tfModulesPath.toFile().exists()) {
                response.append(this.tfModulesPath.toString()).append('\n');
                FileUtils.forceDelete((File)this.tfModulesPath.toFile());
            }
            List<Path> terraformModuleFiles = this.recursivelyWalk(this.tfRootModulePath, path -> path.getParent().toAbsolutePath().toString().endsWith(String.format(".terraform%1$smodules", File.separator)) || path.getFileName().toString().contains(".tfstate"));
            for (Path file2 : terraformModuleFiles) {
                if (isWindows && file2.getParent().endsWith(String.format(".terraform%1$smodules", File.separator))) {
                    try {
                        response.append(file2.toString()).append('\n');
                        file2.toFile().delete();
                    }
                    catch (Exception e) {
                        response.append("**failed to delete ").append(file2.toString()).append('\n');
                    }
                }
                if (!file2.toFile().exists()) continue;
                response.append(file2.toString()).append('\n');
                FileUtils.forceDelete((File)file2.toFile());
            }
            Files.walk(this.tfRootModulePath, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".terraform")).map(Path::toFile).forEach(file -> {
                response.append(file.toString()).append('\n');
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (Exception ex) {
                    response.append("**failed to delete ").append(file.toString()).append('\n');
                }
            });
            return response.toString();
        }
        catch (IOException e) {
            throw new TerraformException(e);
        }
    }

    private List<Path> recursivelyWalk(Path path, Predicate<Path> condition) {
        ArrayList<Path> pathCollection = new ArrayList<Path>();
        try {
            for (File file : path.toFile().listFiles()) {
                pathCollection.addAll(this.recursivelyWalk(file.toPath(), condition));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (condition.test(path)) {
            pathCollection.add(path);
        }
        return pathCollection;
    }
}

