/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.terraform.api;

import com.deliveredtechnologies.io.Executable;
import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.api.TerraformOperation;
import com.deliveredtechnologies.terraform.api.TerraformOption;
import com.deliveredtechnologies.terraform.api.converters.TfCliOptionBuilder;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;

public abstract class TerraformCliOperation
implements TerraformOperation<String> {
    private static final String TIMEOUT = "timeout";
    private Executable terraform;
    private TfCliOptionBuilder tfCliOptionBuilder = new TfCliOptionBuilder(TfCliOptionBuilder.initializeFormatterRegistry());

    public TerraformCliOperation(Executable terraform) {
        this.terraform = terraform;
    }

    public TerraformCliOperation(Executable terraform, Logger logger) {
        this.terraform = terraform;
        this.terraform.setLogger(logger);
    }

    @Override
    public String execute(Properties properties) throws TerraformException {
        String options = this.tfCliOptionBuilder.convert(this.getTerraformParams(), properties);
        try {
            if (properties.containsKey(TIMEOUT)) {
                return this.terraform.execute(options.toString(), Integer.parseInt(properties.get(TIMEOUT).toString()));
            }
            return this.terraform.execute(options.toString());
        }
        catch (IOException | InterruptedException e) {
            throw new TerraformException(e.getMessage(), e);
        }
    }

    protected abstract TerraformOption[] getTerraformParams();
}

