/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.terraform.api.converters;

import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.api.TerraformOption;
import com.deliveredtechnologies.terraform.api.converters.TfOptionFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class TfCliOptionBuilder {
    private Map<String, TfOptionFormatter> registry;

    public TfCliOptionBuilder(Map<String, TfOptionFormatter> registry) {
        this.registry = registry;
    }

    public String convert(TerraformOption[] params, Properties properties) throws TerraformException {
        StringBuilder sb = new StringBuilder();
        for (TerraformOption param : params) {
            if (!properties.containsKey(param.getPropertyName()) && param.getDefault() == null) continue;
            TfOptionFormatter converter = Optional.ofNullable(this.registry.get(param.toString().toLowerCase())).orElse(this.registry.get("default"));
            sb.append(converter.convert(param.getFormat(), properties.getOrDefault((Object)param.getPropertyName(), param.getDefault())));
        }
        return sb.toString();
    }

    public static Map<String, TfOptionFormatter> initializeFormatterRegistry() {
        HashMap<String, TfOptionFormatter> registry = new HashMap<String, TfOptionFormatter>();
        Reflections reflections = new Reflections(TfOptionFormatter.class.getPackage().getName(), new Scanner[0]);
        Set classes = reflections.getSubTypesOf(TfOptionFormatter.class);
        for (Class clazz : classes) {
            try {
                TfOptionFormatter converter = (TfOptionFormatter)clazz.newInstance();
                registry.put(converter.getClass().getSimpleName().toLowerCase().replace("optionformatter", ""), converter);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return registry;
    }
}

