/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.terraform.api.converters;

import com.deliveredtechnologies.terraform.TerraformException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public interface TfOptionFormatter {
    public String convert(String var1, Object var2) throws TerraformException;

    default public String csvConverter(String format, String csv) {
        StringBuilder sb = new StringBuilder();
        for (String var : csv.split(",")) {
            sb.append(String.format(format, var.trim()));
        }
        return sb.toString();
    }

    default public String convertMapToCommandLineOptions(String format, Map<String, Object> map) throws TerraformException {
        ObjectMapper mapper = new ObjectMapper();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object val = entry.getValue();
            try {
                sb.append(String.format("%s \"%s=%s\" ", format, entry.getKey(), val instanceof String ? val : mapper.writeValueAsString(val)));
            }
            catch (JsonProcessingException e) {
                throw new TerraformException(e);
            }
        }
        return sb.toString();
    }
}

