/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.terraform.handler;

import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.TerraformUtils;
import com.deliveredtechnologies.terraform.handler.TerraformHandler;
import com.deliveredtechnologies.terraform.handler.TerraformHandlerException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.slf4j.Logger;

public class TerraformChainHandler {
    private Logger logger;
    String tfRootDir;
    Set<Class<? extends TerraformHandler>> handlerClasses;

    public TerraformChainHandler(String tfRootDir, Logger logger) throws TerraformException, IOException {
        this.logger = logger;
        this.tfRootDir = (StringUtils.isEmpty((CharSequence)tfRootDir) ? TerraformUtils.getDefaultTerraformRootModuleDir() : TerraformUtils.getTerraformRootModuleDir(tfRootDir)).toString();
        this.handlerClasses = this.getHandlerClasses();
    }

    private Set<Class<? extends TerraformHandler>> getHandlerClasses() {
        Reflections reflections = new Reflections(new Object[]{this.getClass().getPackage()});
        return reflections.getSubTypesOf(TerraformHandler.class);
    }

    public void initiateChain(Properties properties) throws TerraformHandlerException {
        for (Class<? extends TerraformHandler> terraformHandler : this.handlerClasses) {
            try {
                Class<?> cls = Class.forName(terraformHandler.getName());
                Object obj = cls.getConstructor(String.class, Logger.class).newInstance(this.tfRootDir, this.logger);
                ((TerraformHandler)obj).doAction(properties);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TerraformHandlerException("Failed to invoke " + terraformHandler.getName(), e);
            }
        }
    }
}

