/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.terraform.handler;

import com.deliveredtechnologies.io.CommandLine;
import com.deliveredtechnologies.io.Executable;
import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.TerraformUtils;
import com.deliveredtechnologies.terraform.handler.TerraformHandler;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerraformPlanS3Handler
extends TerraformHandler {
    private Logger logger;
    private static final Logger LOGGER = LoggerFactory.getLogger(TerraformUtils.class);
    private Executable executable;

    public TerraformPlanS3Handler(String tfRootDir, Logger logger) throws IOException, TerraformException {
        this(new CommandLine(tfRootDir == null ? TerraformUtils.getDefaultTerraformRootModuleDir() : TerraformUtils.getTerraformRootModuleDir(tfRootDir), logger), logger);
    }

    public TerraformPlanS3Handler(Executable executable, Logger logger) {
        this.executable = executable;
        this.logger = logger;
    }

    @Override
    public void doAction(Properties properties) {
        if (properties.containsKey("planOutputFile") && properties.getProperty("planOutputFile").startsWith("s3")) {
            try {
                String planFile = properties.getProperty("planOutputFile");
                String fileName = planFile.substring(planFile.lastIndexOf("/")).replaceAll("/", "");
                if (properties.containsKey("kmsKeyId")) {
                    LOGGER.debug("uploading plan files to Amazon S3 with kms encryption");
                    this.executable.execute(String.format("aws s3 cp %1$s %2$s --sse aws:kms --sse-kms-key-id %3$s", fileName, planFile, properties.getProperty("kmsKeyId")));
                } else {
                    LOGGER.debug("uploading plan files to Amazon S3 with default encryption (SSE:256)");
                    this.executable.execute(String.format("aws s3 cp %1$s %2$s", fileName, planFile));
                }
            }
            catch (IOException | InterruptedException e) {
                this.logger.error("Unable to get " + properties.getProperty("planOutputFile") + "; " + e.getMessage());
            }
        }
    }
}

