/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.io;

import com.deliveredtechnologies.maven.io.Compressable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class CompressableGZipTarFile
implements Compressable {
    private static int BUFFER_SIZE = 4096;
    private Set<Path> filesToCompress = new HashSet<Path>();
    private String filename;
    private Optional<Path> relativizeFrom = Optional.empty();

    public CompressableGZipTarFile(String filename) {
        this(filename, null);
    }

    public CompressableGZipTarFile(String filename, Path relativizeFrom) {
        this.filename = filename;
        this.relativizeFrom = Optional.ofNullable(relativizeFrom);
    }

    @Override
    public boolean addToCompressedFile(Path artifactToAdd) {
        return this.filesToCompress.add(artifactToAdd);
    }

    @Override
    public Path compress() throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.filename);
             TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(fileOutputStream));){
            tarArchiveOutputStream.setBigNumberMode(1);
            tarArchiveOutputStream.setLongFileMode(2);
            for (Path srcPath : this.filesToCompress) {
                this.compressFile(tarArchiveOutputStream, srcPath.getFileName().toString(), srcPath);
            }
        }
        return Paths.get(this.filename, new String[0]);
    }

    private void compressFile(TarArchiveOutputStream tarArchiveOutputStream, String filename, Path source) throws IOException {
        File srcFile = source.toFile();
        tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(srcFile, this.relativizeFrom.map(path -> path.relativize(source)).orElse(source).toString()));
        if (srcFile.isDirectory()) {
            tarArchiveOutputStream.closeArchiveEntry();
            for (File childFile : srcFile.listFiles()) {
                String childFilename = childFile.getName();
                this.compressFile(tarArchiveOutputStream, String.format("%1$s/%2$s", filename, childFilename), source.resolve(childFilename));
            }
            return;
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcFile));
        IOUtils.copy((InputStream)bis, (OutputStream)tarArchiveOutputStream);
        tarArchiveOutputStream.closeArchiveEntry();
        bis.close();
    }
}

