/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.io;

import com.deliveredtechnologies.maven.io.Expandable;
import com.deliveredtechnologies.maven.io.IterableZipInputStream;
import com.deliveredtechnologies.maven.logs.Slf4jMavenAdapter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.LoggerFactory;

public class ExpandableZippedArtifact
implements Expandable {
    private static int BUFFER_SIZE = 4096;
    private Path zipFile;
    private Log log;

    public ExpandableZippedArtifact(Path zipFile, Log log) {
        this.zipFile = zipFile;
        this.log = log;
    }

    public ExpandableZippedArtifact(Path zipFile) {
        this(zipFile, new Slf4jMavenAdapter(LoggerFactory.getLogger(ExpandableZippedArtifact.class)));
    }

    @Override
    public Optional<Path> expand() {
        Path artifactDir;
        this.log.info((CharSequence)("Expanding " + this.zipFile));
        try (IterableZipInputStream zipStream = new IterableZipInputStream(new FileInputStream(this.zipFile.toFile()));){
            String[] zipFilenamePathSplit = this.zipFile.getFileName().toString().split(File.separator.equals("/") ? "\\/" : "\\\\");
            String[] zipFilenameSplitByHyphen = zipFilenamePathSplit[zipFilenamePathSplit.length - 1].split("-");
            String artifactName = Arrays.stream(zipFilenameSplitByHyphen).filter(s -> !s.startsWith("SNAPSHOT")).filter(s -> !s.equals("rc")).filter(s -> !s.equals("tf")).filter(s -> !s.equals("module")).filter(s -> {
                if (s.contains(".")) {
                    String[] splitByDot = s.split("\\.");
                    return !StringUtils.isNumeric((CharSequence)splitByDot[0]) && !splitByDot[splitByDot.length - 1].equals("zip");
                }
                return true;
            }).reduce("", (s1, s2) -> s1 + (s1.length() > 0 ? "-" : "") + s2);
            Path modulesDir = this.zipFile.getParent();
            artifactDir = Paths.get(modulesDir.toString(), artifactName);
            artifactDir.toFile().mkdir();
            for (ZipEntry entry : zipStream) {
                if (entry.isDirectory()) {
                    Paths.get(modulesDir.toString(), artifactName, entry.getName()).toFile().mkdir();
                    continue;
                }
                this.extractFile(zipStream, Paths.get(modulesDir.toString(), artifactName, entry.getName()));
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Error expanding " + this.zipFile.getFileName()), (Throwable)e);
            return Optional.empty();
        }
        if (!this.zipFile.toFile().delete()) {
            this.log.warn((CharSequence)("Unable to delete " + this.zipFile.toAbsolutePath()));
        }
        return Optional.of(artifactDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFile(ZipInputStream zipStream, Path filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath.toString()));){
            int read;
            byte[] buffer = new byte[BUFFER_SIZE];
            while ((read = zipStream.read(buffer)) >= 0) {
                bos.write(buffer, 0, read);
            }
        }
        finally {
            zipStream.closeEntry();
        }
    }
}

