/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IterableZipInputStream
extends ZipInputStream
implements Iterable<ZipEntry> {
    public IterableZipInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        final IterableZipInputStream self = this;
        return new Iterator<ZipEntry>(){
            ZipEntry next = null;

            @Override
            public boolean hasNext() {
                try {
                    this.next = self.getNextEntry();
                    return this.next != null;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public ZipEntry next() {
                return this.next;
            }
        };
    }

    @Override
    public void forEach(Consumer<? super ZipEntry> action) {
        for (ZipEntry entry : this) {
            action.accept(entry);
        }
    }
}

