/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.terraform;

import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.api.TerraformOperation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class TerraformDeploy
implements TerraformOperation<String> {
    private static String PACKAGING = "zip";
    private Log log;
    private MavenProject project;

    public TerraformDeploy(Log log, MavenProject project) {
        this.log = log;
        this.project = project;
    }

    public String execute(Properties properties) throws TerraformException {
        this.deployFileToMavenRepo((Invoker)new DefaultInvoker(), (InvocationRequest)new DefaultInvocationRequest(), System.getProperties());
        return "Successfully deployed";
    }

    final Properties deployFileToMavenRepo(Invoker invoker, InvocationRequest request, Properties properties) throws TerraformException {
        Properties deployFileProps = new Properties();
        deployFileProps.put(TerraformDeployParam.url.toString(), properties.getOrDefault((Object)TerraformDeployParam.url.toString(), String.format("file://%1$s", Paths.get(System.getenv("HOME"), ".m2", "repository"))).toString());
        if (!properties.containsKey(TerraformDeployParam.file.toString())) {
            Path targetPath = Paths.get("target", new String[0]).resolve(String.format("%1$s-%2$s.zip", this.project.getArtifactId(), this.project.getVersion()));
            deployFileProps.setProperty(TerraformDeployParam.file.toString(), targetPath.toString());
        } else {
            deployFileProps.setProperty(TerraformDeployParam.file.toString(), properties.get(TerraformDeployParam.file.toString()).toString());
        }
        deployFileProps.put(TerraformDeployParam.packaging.toString(), PACKAGING);
        this.log.info((CharSequence)String.format("Deploying %1$s to %2$s", deployFileProps.getProperty(TerraformDeployParam.file.toString()), deployFileProps.getProperty(TerraformDeployParam.url.toString())));
        if (properties.containsKey(TerraformDeployParam.generatePom.toString())) {
            deployFileProps.put(TerraformDeployParam.generatePom.toString(), properties.getProperty(TerraformDeployParam.generatePom.toString()));
            deployFileProps.put(TerraformDeployParam.artifactId.toString(), this.project.getArtifactId());
            deployFileProps.put(TerraformDeployParam.groupId.toString(), this.project.getGroupId());
            deployFileProps.put(TerraformDeployParam.version.toString(), this.project.getVersion());
            this.log.info((CharSequence)"Using generated POM");
        } else {
            if (!properties.containsKey(TerraformDeployParam.pomFile.toString())) {
                Path pomFile = Paths.get(".flattened-pom.xml", new String[0]);
                deployFileProps.setProperty(TerraformDeployParam.pomFile.toString(), pomFile.toAbsolutePath().toString());
            } else {
                deployFileProps.setProperty(TerraformDeployParam.pomFile.toString(), properties.get(TerraformDeployParam.pomFile.toString()).toString());
            }
            this.log.info((CharSequence)String.format("Using POM: %1$s", deployFileProps.getProperty(TerraformDeployParam.pomFile.toString())));
        }
        if (properties.containsKey(TerraformDeployParam.repositoryId.toString())) {
            deployFileProps.put(TerraformDeployParam.repositoryId.toString(), properties.getProperty(TerraformDeployParam.repositoryId.toString()));
        }
        request.setGoals(Arrays.asList("deploy:deploy-file"));
        request.setProperties(deployFileProps);
        try {
            invoker.execute(request);
            return deployFileProps;
        }
        catch (MavenInvocationException e) {
            throw new TerraformException("Unable to deploy to Maven repo", (Throwable)e);
        }
    }

    static enum TerraformDeployParam {
        file,
        pomFile,
        url,
        packaging,
        generatePom,
        artifactId,
        groupId,
        version,
        repositoryId;

    }
}

