/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.terraform;

import com.deliveredtechnologies.maven.io.ExpandableZippedArtifact;
import com.deliveredtechnologies.maven.logs.Slf4jMavenAdapter;
import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.TerraformUtils;
import com.deliveredtechnologies.terraform.api.TerraformOperation;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.LoggerFactory;

public class TerraformGet
implements TerraformOperation<List<Path>> {
    private static final String PACKAGING = "zip";
    private Path tfModules;
    private Log log;

    public TerraformGet(Log log, String tfModules) throws IOException {
        this(log, StringUtils.isEmpty((CharSequence)tfModules) ? null : Paths.get(tfModules, new String[0]));
    }

    protected TerraformGet(Log log, Path tfModules) throws IOException {
        this.log = log;
        Path path = this.tfModules = tfModules == null ? TerraformUtils.getDefaultTfModulesDir() : tfModules;
        if (!this.tfModules.toFile().exists()) {
            FileUtils.forceMkdir((File)this.tfModules.toFile());
        }
    }

    public TerraformGet(Log log) throws IOException {
        this(log, (String)null);
    }

    public TerraformGet() throws IOException {
        this((Log)new Slf4jMavenAdapter(LoggerFactory.getLogger(TerraformGet.class)), (String)null);
    }

    public List<Path> execute(Properties properties) throws TerraformException {
        if (Boolean.valueOf(properties.getProperty("skipTfGet", "false")).booleanValue()) {
            return new ArrayList<Path>();
        }
        this.getDependenciesFromMavenRepo((Invoker)new DefaultInvoker(), (InvocationRequest)new DefaultInvocationRequest());
        return this.expandMavenArtifacts(this.tfModules);
    }

    final void getDependenciesFromMavenRepo(Invoker invoker, InvocationRequest request) throws TerraformException {
        this.log.info((CharSequence)"Getting artifact dependencies from Maven");
        Properties properties = new Properties();
        properties.setProperty("outputDirectory", this.tfModules.toAbsolutePath().toString());
        properties.setProperty("includeTypes", PACKAGING);
        request.setGoals(Arrays.asList("dependency:copy-dependencies"));
        request.setProperties(properties);
        try {
            invoker.execute(request);
        }
        catch (MavenInvocationException e) {
            throw new TerraformException("Unable to copy dependencies from Maven repo", (Throwable)e);
        }
    }

    final List<Path> expandMavenArtifacts(Path directory) throws TerraformException {
        this.log.info((CharSequence)("Expanding artifacts from " + directory.toAbsolutePath()));
        try {
            ArrayList<Path> result = new ArrayList<Path>();
            List zipFiles = Files.walk(directory, 1, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".zip")).collect(Collectors.toList());
            for (Path zipFile : zipFiles) {
                result.add(new ExpandableZippedArtifact(zipFile, this.log).expand().orElseThrow(() -> new TerraformException("unable to extract " + zipFile.getFileName())));
            }
            return result;
        }
        catch (IOException e) {
            throw new TerraformException("Unable to extract maven artifacts");
        }
    }
}

