/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.terraform;

import com.deliveredtechnologies.maven.io.ExpandableZippedArtifact;
import com.deliveredtechnologies.maven.terraform.TerraformGet;
import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.api.TerraformOperation;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class TerraformGetMavenRootArtifact
implements TerraformOperation<String> {
    private Path workingPath = Paths.get(System.getProperty("user.dir"), ".tfproject");
    private Path mainTfPath;
    private String tfRootDir;
    private String artifact;
    private Log log;

    public TerraformGetMavenRootArtifact(String artifact, Log log) {
        this(artifact, null, log);
    }

    public TerraformGetMavenRootArtifact(String artifact, String tfRootDir, Log log) {
        this.log = log;
        this.artifact = artifact;
        this.tfRootDir = tfRootDir;
        this.mainTfPath = this.workingPath.resolve("src").resolve("main").resolve("tf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Properties properties) throws TerraformException {
        this.getArtifactFromMavenRepo((Invoker)new DefaultInvoker(), (InvocationRequest)new DefaultInvocationRequest());
        Path expandedArtifactPath = this.expandMavenArtifacts();
        try {
            String userDir = System.getProperty("user.dir");
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                System.setProperty("user.dir", this.workingPath.toAbsolutePath().toString());
                TerraformGet terraformGet = new TerraformGet(this.log, this.mainTfPath.getParent().resolve(".tfmodules").toAbsolutePath().toString());
                terraformGet.execute(properties);
                System.setProperty("user.dir", userDir);
            }
        }
        catch (IOException e) {
            throw new TerraformException((Throwable)e);
        }
        if (!StringUtils.isEmpty((CharSequence)this.tfRootDir)) {
            return expandedArtifactPath.resolve(this.tfRootDir).toAbsolutePath().toString();
        }
        return expandedArtifactPath.toAbsolutePath().toString();
    }

    final void getArtifactFromMavenRepo(Invoker invoker, InvocationRequest request) throws TerraformException {
        this.log.info((CharSequence)"Getting artifact dependencies from Maven");
        String artifactZip = TerraformGetMavenRootArtifact.getArtifactZip(this.artifact);
        Properties properties = new Properties();
        properties.setProperty("artifact", String.format("%1$s:zip", this.artifact));
        properties.setProperty("outputDirectory", this.mainTfPath.toAbsolutePath().toString());
        request.setGoals(Arrays.asList("dependency:copy"));
        request.setProperties(properties);
        try {
            if (!this.mainTfPath.toFile().exists()) {
                FileUtils.forceMkdir((File)this.mainTfPath.toFile());
            }
            invoker.execute(request);
            request.getProperties().setProperty("artifact", String.format("%1$s:pom", this.artifact));
            request.getProperties().setProperty("outputDirectory", this.workingPath.toAbsolutePath().toString());
            request.setProperties(properties);
            invoker.execute(request);
            Optional<Path> pomFile = Files.walk(this.workingPath, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".pom")).findFirst();
            if (pomFile.isPresent()) {
                File workingFile = this.workingPath.resolve("pom.xml").toFile();
                if (workingFile.exists()) {
                    workingFile.delete();
                }
                FileUtils.moveFile((File)pomFile.get().toFile(), (File)workingFile);
            }
        }
        catch (IOException | MavenInvocationException e) {
            throw new TerraformException("Unable to copy dependencies from Maven repo", e);
        }
    }

    final Path expandMavenArtifacts() throws TerraformException {
        String artifactZip = TerraformGetMavenRootArtifact.getArtifactZip(this.artifact);
        Path artifactZipPath = this.mainTfPath.resolve(artifactZip);
        this.log.info((CharSequence)("Expanding artifacts from " + artifactZipPath.toAbsolutePath()));
        return new ExpandableZippedArtifact(artifactZipPath, this.log).expand().orElseThrow(() -> new TerraformException("unable to extract " + artifactZipPath.getFileName()));
    }

    static String getArtifactZip(String artifact) {
        String artifactZip = artifact.indexOf(58) > 0 ? artifact.substring(artifact.indexOf(58) + 1).replace(":", "-") : artifact;
        return artifactZip.endsWith(".zip") ? artifactZip : String.format("%1$s.zip", artifactZip);
    }
}

