/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.terraform;

import com.deliveredtechnologies.maven.io.CompressableGZipTarFile;
import com.deliveredtechnologies.maven.io.CompressableZipFile;
import com.deliveredtechnologies.maven.logs.MavenSlf4jAdapter;
import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.TerraformUtils;
import com.deliveredtechnologies.terraform.api.TerraformOperation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerraformPackage
implements TerraformOperation<String> {
    static final String targetDir = "target";
    static final String targetTfRootDir = "tf-root-module";
    static final List<String> excludedFiles = Arrays.asList(".terraform", "terraform.tfstate", "terraform.tfstate.backup", ".terraform.tfstate.lock.info");
    private Logger logger;
    private MavenProject project;

    public TerraformPackage(MavenProject project, Logger logger) {
        this.logger = logger;
        this.project = project;
    }

    public TerraformPackage(MavenProject project, Log log) {
        this(project, new MavenSlf4jAdapter(log));
    }

    public TerraformPackage(MavenProject project) {
        this(project, LoggerFactory.getLogger(TerraformPackage.class));
    }

    public String execute(Properties properties) throws TerraformException {
        try {
            Path targetPath = Paths.get(targetDir, new String[0]);
            Path targetTfRootPath = targetPath.resolve(targetTfRootDir);
            String tfModulesDir = properties.getProperty(TerraformPackageParams.tfModulesDir.toString());
            String tfRootDir = properties.getProperty(TerraformPackageParams.tfRootDir.toString());
            String tfVarFiles = properties.getProperty(TerraformPackageParams.tfVarFiles.toString());
            Object isFatTarObj = properties.getOrDefault((Object)TerraformPackageParams.fatTar.toString(), (Object)false);
            boolean isFatTar = isFatTarObj instanceof Boolean ? (Boolean)isFatTarObj : Boolean.valueOf(isFatTarObj.toString());
            Path tfModulesPath = !StringUtils.isEmpty((String)tfModulesDir) ? Paths.get(tfModulesDir, new String[0]) : TerraformUtils.getDefaultTfModulesDir();
            this.logger.debug(String.format("tfModulesPath is %1$s", tfModulesPath.toAbsolutePath().toString()));
            File tfSourceFile = Paths.get("src", "main", "tf").toFile();
            Path tfRootPath = !StringUtils.isEmpty((String)tfRootDir) ? TerraformUtils.getTerraformRootModuleDir((String)tfRootDir) : (tfSourceFile.exists() && tfSourceFile.isDirectory() && tfSourceFile.listFiles().length > 1 ? tfSourceFile.toPath() : TerraformUtils.getDefaultTerraformRootModuleDir());
            this.logger.debug(String.format("tfRootPath is %1$s", tfRootPath.toAbsolutePath().toString()));
            ArrayList tfVarFilePaths = StringUtils.isEmpty((String)tfVarFiles) ? new ArrayList() : Arrays.stream(tfVarFiles.split(",")).map(x -> tfRootPath.resolve(x.trim())).collect(Collectors.toList());
            this.logger.debug(String.format("tfVarFiles is %1$s", tfVarFilePaths));
            if (targetTfRootPath.toFile().exists()) {
                FileUtils.forceDelete((File)targetTfRootPath.toFile());
            }
            FileUtils.forceMkdir((File)targetTfRootPath.toFile());
            List tfRootDirFiles = Files.walk(tfRootPath, 1, new FileVisitOption[0]).filter(path -> !path.equals(tfRootPath)).collect(Collectors.toList());
            for (Path file : tfRootDirFiles.stream().filter(f -> !excludedFiles.contains(f.getFileName().toString())).collect(Collectors.toList())) {
                if (file.toFile().isDirectory()) {
                    FileUtils.copyDirectory((File)file.toFile(), (File)targetTfRootPath.resolve(file.getFileName().toString()).toFile(), (FileFilter)new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return excludedFiles.stream().noneMatch(excludedFile -> pathname.getName().endsWith((String)excludedFile));
                        }
                    });
                    continue;
                }
                Files.copy(file, targetTfRootPath.resolve(file.getFileName().toString()), new CopyOption[0]);
            }
            for (Path tfVarFilePath : tfVarFilePaths) {
                Files.copy(tfVarFilePath, targetTfRootPath.resolve(tfVarFilePath.getFileName().toString().replaceAll(".tfvars", "").concat(".auto.tfvars")), new CopyOption[0]);
            }
            if (isFatTar) {
                this.updateDependenciesInTfRoot(targetTfRootPath, tfModulesPath, tfRootPath);
                if (tfModulesPath.toFile().exists() && tfModulesPath.toFile().isDirectory()) {
                    FileUtils.copyDirectory((File)tfModulesPath.toFile(), (File)targetTfRootPath.resolve(tfModulesPath.getFileName().toString()).toFile());
                }
                return String.format("Created fatTar gzipped tar file '%1$s'", this.createGZippedTar(targetPath, targetTfRootPath));
            }
            return String.format("Created zip file '%1$s'", this.createZip(targetPath, targetTfRootPath));
        }
        catch (IOException e) {
            throw new TerraformException(e.getMessage(), (Throwable)e);
        }
    }

    private void updateDependenciesInTfRoot(Path targetTfRootPath, Path tfModulesPath, Path tfRootPath) throws IOException {
        String tfRootToModulesRelativePath = tfRootPath.relativize(tfModulesPath).toString();
        List filesInTargetTfRoot = Files.walk(targetTfRootPath, new FileVisitOption[0]).filter(path -> !path.toFile().isDirectory()).collect(Collectors.toList());
        for (Path file : filesInTargetTfRoot) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader(new FileInputStream(file.toFile())));
                 BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file.resolveSibling(file.getFileName().toString() + ".working").toFile())));){
                while (fileReader.ready()) {
                    fileWriter.write(fileReader.readLine().replace(tfRootToModulesRelativePath.replace('\\', '/'), tfModulesPath.getFileName().toString()));
                    fileWriter.newLine();
                }
            }
            Files.delete(file);
            Files.move(file.resolveSibling(file.getFileName().toString() + ".working"), file, new CopyOption[0]);
        }
    }

    private String createZip(Path targetDir, Path targetTfRootPath) throws IOException {
        String zipFilename = targetDir.resolve(String.format("%1$s-%2$s.zip", this.project.getArtifactId(), this.project.getVersion())).toString();
        CompressableZipFile compressor = new CompressableZipFile(zipFilename);
        Files.walk(targetTfRootPath, 1, new FileVisitOption[0]).filter(path -> !path.equals(targetTfRootPath)).forEach(compressor::addToCompressedFile);
        compressor.compress();
        return zipFilename;
    }

    private String createGZippedTar(Path targetDir, Path targetTfRootPath) throws IOException {
        String tarFilename = targetDir.resolve(String.format("%1$s-%2$s.tar.gz", this.project.getArtifactId(), this.project.getVersion())).toString();
        CompressableGZipTarFile compressor = new CompressableGZipTarFile(tarFilename, targetTfRootPath);
        Files.walk(targetTfRootPath, 1, new FileVisitOption[0]).filter(path -> !path.equals(targetTfRootPath)).forEach(compressor::addToCompressedFile);
        compressor.compress();
        return tarFilename;
    }

    static enum TerraformPackageParams {
        tfModulesDir,
        tfRootDir,
        tfVarFiles,
        fatTar;

    }
}

