/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.terraform.mojo;

import com.deliveredtechnologies.maven.logs.MavenSlf4jAdapter;
import com.deliveredtechnologies.maven.terraform.TerraformGetMavenRootArtifact;
import com.deliveredtechnologies.maven.terraform.mojo.TerraformMojo;
import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.api.TerraformApply;
import com.deliveredtechnologies.terraform.handler.TerraformChainHandler;
import com.deliveredtechnologies.terraform.handler.TerraformHandlerException;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;

@Mojo(name="apply", requiresProject=false)
public class Apply
extends TerraformMojo<String> {
    @Parameter(property="tfRootDir")
    String tfRootDir;
    @Parameter(property="artifact")
    String artifact;
    @Parameter(property="tfVars")
    String tfVars;
    @Parameter(property="tfVarFiles")
    String tfVarFiles;
    @Parameter(property="lockTimeout")
    String lockTimeout;
    @Parameter(property="target")
    String target;
    @Parameter(property="plan")
    String plan;
    @Parameter(property="noColor")
    boolean noColor = true;
    @Parameter(property="timeout")
    long timeout;
    @Parameter(property="refreshState")
    boolean refreshState = true;
    @Parameter(property="autoApprove")
    boolean autoApprove = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!StringUtils.isEmpty((CharSequence)this.artifact)) {
                TerraformGetMavenRootArtifact mavenRepoExecutableOp = new TerraformGetMavenRootArtifact(this.artifact, this.tfRootDir, this.getLog());
                this.tfRootDir = mavenRepoExecutableOp.execute(this.getFieldsAsProperties());
            }
            TerraformChainHandler terraformChainHandler = new TerraformChainHandler(this.tfRootDir, (Logger)new MavenSlf4jAdapter(this.getLog()));
            terraformChainHandler.initiateChain(this.getFieldsAsProperties());
            this.execute(new TerraformApply(this.tfRootDir), this.getFieldsAsProperties());
        }
        catch (TerraformException | TerraformHandlerException | IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

