/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.terraform.mojo;

import com.deliveredtechnologies.maven.terraform.TerraformGetMavenRootArtifact;
import com.deliveredtechnologies.maven.terraform.mojo.TerraformMojo;
import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.TerraformUtils;
import com.deliveredtechnologies.terraform.api.TerraformInit;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Execute(goal="get")
@Mojo(name="init", requiresProject=false)
public class Init
extends TerraformMojo<String> {
    @Parameter(property="tfRootDir")
    String tfRootDir;
    @Parameter(property="artifact")
    String artifact;
    @Parameter(property="pluginDir")
    File pluginDir;
    @Parameter(property="getPlugins")
    boolean getPlugins;
    @Parameter(property="backendConfig")
    String backendConfig;
    @Parameter(property="verifyPlugins")
    boolean verifyPlugins;
    @Parameter(property="skipTfGet")
    boolean skipTfGet = false;
    @Parameter(property="backendType")
    String backendType;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!StringUtils.isEmpty((CharSequence)this.artifact)) {
                TerraformGetMavenRootArtifact mavenRepoExecutableOp = new TerraformGetMavenRootArtifact(this.artifact, this.tfRootDir, this.getLog());
                this.tfRootDir = mavenRepoExecutableOp.execute(this.getFieldsAsProperties());
            }
            if (!StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{this.backendType})) {
                Path dir = this.tfRootDir == null ? TerraformUtils.getDefaultTerraformRootModuleDir() : TerraformUtils.getTerraformRootModuleDir((String)this.tfRootDir);
                StringBuilder backend = new StringBuilder();
                backend.append("{ \"terraform\": { \"backend\": { \"");
                backend.append(this.backendType);
                backend.append("\": {} } } }");
                Files.write(Paths.get(dir.toString(), "backend.generated.tf.json"), backend.toString().getBytes(), new OpenOption[0]);
            }
            this.execute(new TerraformInit(this.tfRootDir), this.getFieldsAsProperties());
        }
        catch (TerraformException | IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

