/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.terraform.mojo;

import com.deliveredtechnologies.terraform.TerraformException;
import com.deliveredtechnologies.terraform.api.TerraformOperation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class TerraformMojo<T>
extends AbstractMojo {
    protected final void execute(TerraformOperation<T> tfOperation, Properties properties) throws MojoExecutionException {
        try {
            tfOperation.execute(properties);
        }
        catch (TerraformException e) {
            throw new MojoExecutionException("Failed to execute terraform operation", (Exception)((Object)e));
        }
    }

    protected final void execute(TerraformOperation<T> tfOperation) throws MojoExecutionException {
        this.execute(tfOperation, this.getFieldsAsProperties());
    }

    protected final Properties getFieldsAsProperties() throws MojoExecutionException {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        List fieldList = Arrays.stream(clazz.getDeclaredFields()).collect(Collectors.toList());
        Properties properties = new Properties();
        for (Field field : fieldList) {
            try {
                field.setAccessible(true);
                Object fieldVal = field.get((Object)this);
                if (fieldVal == null || fieldVal.equals(false) && !field.getName().startsWith("refresh") || Number.class.isAssignableFrom(fieldVal.getClass()) && ((Number)fieldVal).longValue() <= 0L) continue;
                if (field.getName().equalsIgnoreCase("tfvars")) {
                    fieldVal = this.getTFvars(fieldVal);
                }
                properties.put(field.getName(), fieldVal);
            }
            catch (NullPointerException fieldVal) {
            }
            catch (IllegalAccessException iae) {
                throw new MojoExecutionException("Unable to access " + field.getName() + " from Mojo!", (Exception)iae);
            }
            catch (JsonProcessingException jpe) {
                throw new MojoExecutionException("Unable to convert " + field.getName() + " to json", (Exception)((Object)jpe));
            }
        }
        return properties;
    }

    private Object getTFvars(Object value) throws JsonProcessingException {
        String val = (String)value;
        if (val.contains("{")) {
            val = StringUtils.stripStart((String)StringUtils.stripEnd((String)val, (String)"'"), (String)"'");
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readValue(val, Map.class);
        }
        return value;
    }
}

