/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.maven.terraform.mojo;

import com.deliveredtechnologies.maven.terraform.mojo.TerraformMojo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="wrapper")
public class Wrapper
extends TerraformMojo<String> {
    @Parameter(property="distributionSite")
    String indistributionSite;
    @Parameter(property="releaseDir")
    String inreleaseDir;
    @Parameter(property="releaseName")
    String inreleaseName;
    @Parameter(property="releaseVer")
    String inreleaseVer;
    @Parameter(property="releaseOS")
    String inreleaseOS;
    @Parameter(property="releaseSuffix")
    String inreleaseSuffix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Throwable throwable;
        File tf_dir;
        String os_name = System.getProperty("os.name");
        int windowsIndex = os_name.indexOf("indow");
        if (this.inreleaseOS == null) {
            this.inreleaseOS = windowsIndex != -1 ? "windows" : "linux";
        }
        if (!(tf_dir = new File(".tf")).exists()) {
            if (tf_dir.mkdir()) {
                this.getLog().info((CharSequence)"Directory .tf is created");
            } else {
                this.getLog().info((CharSequence)"Failed to create directory .tf");
            }
        }
        String[] tfwFileNames = new String[]{"tfw", "tfw.cmd", "tfw.ps1", "terraform-maven.properties"};
        Path tfWrapperPath = Paths.get(".tf", new String[0]);
        for (String tfwFileName : tfwFileNames) {
            File tfwFile = tfWrapperPath.resolve(tfwFileName).toFile();
            if (tfwFileName.endsWith(".properties") && tfwFile.exists()) continue;
            try {
                FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getClassLoader().getResource("tf/" + tfwFileName), (File)tfWrapperPath.resolve(tfwFileName).toFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Unable to create %s!", tfwFileName), (Exception)e);
            }
            tfwFile.setExecutable(true);
        }
        File propFile = new File(String.format(".tf%sterraform-maven.properties", File.separator));
        Properties prop = new Properties();
        prop.setProperty("releaseDir", ".tf");
        try {
            throwable = null;
            try (FileInputStream fis = new FileInputStream(propFile);){
                prop.load(fis);
            }
            catch (Throwable tfwFile) {
                throwable = tfwFile;
                throw tfwFile;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to load properties from %s!", propFile.getName()), (Exception)e);
        }
        if (this.indistributionSite != null) {
            prop.setProperty("distributionSite", this.indistributionSite);
        }
        if (this.inreleaseDir != null) {
            prop.setProperty("releaseDir", this.inreleaseDir);
        }
        if (this.inreleaseName != null) {
            prop.setProperty("releaseName", this.inreleaseName);
        }
        if (this.inreleaseVer != null) {
            prop.setProperty("releaseVer", this.inreleaseVer);
        }
        if (this.inreleaseOS != null) {
            prop.setProperty("releaseOS", this.inreleaseOS);
        }
        if (this.inreleaseSuffix != null) {
            prop.setProperty("releaseSuffix", this.inreleaseSuffix);
        }
        try {
            throwable = null;
            try (BufferedWriter propOut = new BufferedWriter(new FileWriter(propFile));){
                Set<String> keys = prop.stringPropertyNames();
                for (String key : keys) {
                    propOut.write(key + "=" + prop.getProperty(key) + "\n");
                }
                propOut.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to write properties to %s!", propFile.getName()), (Exception)e);
        }
    }
}

