/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation;

import com.demandware.appsec.secure.manipulation.IManipulateOption;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;

public abstract class AbstractManipulator {
    protected final IManipulateOption manipulatorOption;

    protected AbstractManipulator(IManipulateOption manipulatorOption) {
        this.manipulatorOption = manipulatorOption;
    }

    protected String filter(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(input.length());
        try {
            this.filterInternal(input, sb);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return sb.toString();
    }

    protected void filter(String input, Writer writer) throws IOException, IllegalArgumentException {
        if (input == null) {
            return;
        }
        if (writer == null) {
            throw new IllegalArgumentException("Writer cannot be null");
        }
        this.filterInternal(input, writer);
    }

    protected String encode(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(input.length() * 3);
        try {
            this.encodeInternal(input, sb);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return sb.toString();
    }

    protected void encode(String input, Writer writer) throws IOException, IllegalArgumentException {
        if (input == null) {
            return;
        }
        if (writer == null) {
            throw new IllegalArgumentException("Writer cannot be null");
        }
        this.encodeInternal(input, writer);
    }

    protected abstract void encodeInternal(String var1, Appendable var2) throws IOException;

    protected abstract void filterInternal(String var1, Appendable var2) throws IOException;
}

