/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation;

import com.demandware.appsec.secure.manipulation.AbstractManipulator;
import com.demandware.appsec.secure.manipulation.impl.DefaultManipulationType;
import com.demandware.appsec.secure.manipulation.impl.IManipulationType;
import com.demandware.appsec.secure.manipulation.impl.ManipulatorFactory;
import java.io.IOException;
import java.io.Writer;

public class SecureEncoder {
    public static String encode(IManipulationType type, String input) {
        AbstractManipulator manip = ManipulatorFactory.getManipulator(type);
        return manip.encode(input);
    }

    public static void encode(IManipulationType type, String input, Writer writer) {
        AbstractManipulator manip = ManipulatorFactory.getManipulator(type);
        try {
            manip.encode(input, writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("An error occurred while encoding", e);
        }
    }

    public static String encodeCDATAContent(String input) {
        return SecureEncoder.encode(DefaultManipulationType.CDATA_CONTENT_MANIPULATOR, input);
    }

    public static void encodeCDATAContent(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.CDATA_CONTENT_MANIPULATOR, input, out);
    }

    public static String encodeHtmlContent(String input) {
        return SecureEncoder.encode(DefaultManipulationType.HTML_CONTENT_MANIPULATOR, input);
    }

    public static void encodeHtmlContent(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.HTML_CONTENT_MANIPULATOR, input, out);
    }

    public static String encodeHtmlInSingleQuoteAttribute(String input) {
        return SecureEncoder.encode(DefaultManipulationType.HTML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void encodeHtmlInSingleQuoteAttribute(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.HTML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String encodeHtmlInDoubleQuoteAttribute(String input) {
        return SecureEncoder.encode(DefaultManipulationType.HTML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void encodeHtmlInDoubleQuoteAttribute(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.HTML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String encodeHtmlUnquotedAttribute(String input) {
        return SecureEncoder.encode(DefaultManipulationType.HTML_UNQUOTED_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void encodeHtmlUnquotedAttribute(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.HTML_UNQUOTED_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String encodeJavaScriptInHTML(String input) {
        return SecureEncoder.encode(DefaultManipulationType.JAVASCRIPT_HTML_MANIPULATOR, input);
    }

    public static void encodeJavaScriptInHTML(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.JAVASCRIPT_HTML_MANIPULATOR, input, out);
    }

    public static String encodeJavaScriptInAttribute(String input) {
        return SecureEncoder.encode(DefaultManipulationType.JAVASCRIPT_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void encodeJavaScriptInAttribute(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.JAVASCRIPT_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String encodeJavaScriptInBlock(String input) {
        return SecureEncoder.encode(DefaultManipulationType.JAVASCRIPT_BLOCK_MANIPULATOR, input);
    }

    public static void encodeJavaScriptInBlock(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.JAVASCRIPT_BLOCK_MANIPULATOR, input, out);
    }

    public static String encodeJavaScriptInSource(String input) {
        return SecureEncoder.encode(DefaultManipulationType.JAVASCRIPT_SOURCE_MANIPULATOR, input);
    }

    public static void encodeJavaScriptInSource(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.JAVASCRIPT_SOURCE_MANIPULATOR, input, out);
    }

    public static String encodeJSONValue(String input) {
        return SecureEncoder.encode(DefaultManipulationType.JSON_VALUE_MANIPULATOR, input);
    }

    public static void encodeJSONValue(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.JSON_VALUE_MANIPULATOR, input, out);
    }

    public static String encodeUriComponent(String input) {
        return SecureEncoder.encode(DefaultManipulationType.URI_COMPONENT_MANIPULATOR, input);
    }

    public static void encodeUriComponent(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.URI_COMPONENT_MANIPULATOR, input, out);
    }

    public static String encodeUriComponentStrict(String input) {
        return SecureEncoder.encode(DefaultManipulationType.URI_STRICT_COMPONENT_MANIPULATOR, input);
    }

    public static void encodeUriComponentStrict(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.URI_STRICT_COMPONENT_MANIPULATOR, input, out);
    }

    public static String encodeXmlContent(String input) {
        return SecureEncoder.encode(DefaultManipulationType.XML_CONTENT_MANIPULATOR, input);
    }

    public static void encodeXmlContent(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.XML_CONTENT_MANIPULATOR, input, out);
    }

    public static String encodeXmlInSingleQuoteAttribute(String input) {
        return SecureEncoder.encode(DefaultManipulationType.XML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void encodeXmlInSingleQuoteAttribute(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.XML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String encodeXmlInDoubleQuoteAttribute(String input) {
        return SecureEncoder.encode(DefaultManipulationType.XML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void encodeXmlInDoubleQuoteAttribute(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.XML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String encodeXmlCommentContent(String input) {
        return SecureEncoder.encode(DefaultManipulationType.XML_COMMENT_MANIPULATOR, input);
    }

    public static void encodeXmlCommentContent(String input, Writer out) {
        SecureEncoder.encode(DefaultManipulationType.XML_COMMENT_MANIPULATOR, input, out);
    }

    protected SecureEncoder() {
    }
}

