/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation;

import com.demandware.appsec.secure.manipulation.AbstractManipulator;
import com.demandware.appsec.secure.manipulation.impl.DefaultManipulationType;
import com.demandware.appsec.secure.manipulation.impl.IManipulationType;
import com.demandware.appsec.secure.manipulation.impl.ManipulatorFactory;
import java.io.IOException;
import java.io.Writer;

public class SecureFilter {
    public static String filter(IManipulationType type, String input) {
        AbstractManipulator manip = ManipulatorFactory.getManipulator(type);
        return manip.filter(input);
    }

    public static void filter(IManipulationType type, String input, Writer writer) {
        AbstractManipulator manip = ManipulatorFactory.getManipulator(type);
        try {
            manip.filter(input, writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("An error occurred while filtering", e);
        }
    }

    public static String filterCDATAContent(String input) {
        return SecureFilter.filter(DefaultManipulationType.CDATA_CONTENT_MANIPULATOR, input);
    }

    public static void filterCDATAContent(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.CDATA_CONTENT_MANIPULATOR, input, out);
    }

    public static String filterHtmlContent(String input) {
        return SecureFilter.filter(DefaultManipulationType.HTML_CONTENT_MANIPULATOR, input);
    }

    public static void filterHtmlContent(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.HTML_CONTENT_MANIPULATOR, input, out);
    }

    public static String filterHtmlInSingleQuoteAttribute(String input) {
        return SecureFilter.filter(DefaultManipulationType.HTML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void filterHtmlInSingleQuoteAttribute(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.HTML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String filterHtmlInDoubleQuoteAttribute(String input) {
        return SecureFilter.filter(DefaultManipulationType.HTML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void filterHtmlInDoubleQuoteAttribute(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.HTML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String filterHtmlUnquotedAttribute(String input) {
        return SecureFilter.filter(DefaultManipulationType.HTML_UNQUOTED_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void filterHtmlUnquotedAttribute(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.HTML_UNQUOTED_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String filterJavaScriptInHTML(String input) {
        return SecureFilter.filter(DefaultManipulationType.JAVASCRIPT_HTML_MANIPULATOR, input);
    }

    public static void filterJavaScriptInHTML(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.JAVASCRIPT_HTML_MANIPULATOR, input, out);
    }

    public static String filterJavaScriptInAttribute(String input) {
        return SecureFilter.filter(DefaultManipulationType.JAVASCRIPT_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void filterJavaScriptInAttribute(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.JAVASCRIPT_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String filterJavaScriptInBlock(String input) {
        return SecureFilter.filter(DefaultManipulationType.JAVASCRIPT_BLOCK_MANIPULATOR, input);
    }

    public static void filterJavaScriptInBlock(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.JAVASCRIPT_BLOCK_MANIPULATOR, input, out);
    }

    public static String filterJavaScriptInSource(String input) {
        return SecureFilter.filter(DefaultManipulationType.JAVASCRIPT_SOURCE_MANIPULATOR, input);
    }

    public static void filterJavaScriptInSource(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.JAVASCRIPT_SOURCE_MANIPULATOR, input, out);
    }

    public static String filterJSONValue(String input) {
        return SecureFilter.filter(DefaultManipulationType.JSON_VALUE_MANIPULATOR, input);
    }

    public static void filterJSONValue(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.JSON_VALUE_MANIPULATOR, input, out);
    }

    public static String filterUriComponent(String input) {
        return SecureFilter.filter(DefaultManipulationType.URI_COMPONENT_MANIPULATOR, input);
    }

    public static void filterUriComponent(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.URI_COMPONENT_MANIPULATOR, input, out);
    }

    public static String filterUriComponentStrict(String input) {
        return SecureFilter.filter(DefaultManipulationType.URI_STRICT_COMPONENT_MANIPULATOR, input);
    }

    public static void filterUriComponentStrict(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.URI_STRICT_COMPONENT_MANIPULATOR, input, out);
    }

    public static String filterXmlContent(String input) {
        return SecureFilter.filter(DefaultManipulationType.XML_CONTENT_MANIPULATOR, input);
    }

    public static void filterXmlContent(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.XML_CONTENT_MANIPULATOR, input, out);
    }

    public static String filterXmlInSingleQuoteAttribute(String input) {
        return SecureFilter.filter(DefaultManipulationType.XML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void filterXmlInSingleQuoteAttribute(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.XML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String filterXmlInDoubleQuoteAttribute(String input) {
        return SecureFilter.filter(DefaultManipulationType.XML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR, input);
    }

    public static void filterXmlInDoubleQuoteAttribute(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.XML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR, input, out);
    }

    public static String filterXmlCommentContent(String input) {
        return SecureFilter.filter(DefaultManipulationType.XML_COMMENT_MANIPULATOR, input);
    }

    public static void filterXmlCommentContent(String input, Writer out) {
        SecureFilter.filter(DefaultManipulationType.XML_COMMENT_MANIPULATOR, input, out);
    }

    protected SecureFilter() {
    }
}

