/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation.impl;

import com.demandware.appsec.secure.manipulation.AbstractStringManipulator;
import com.demandware.appsec.secure.manipulation.IManipulateOption;
import java.io.IOException;

class CDATAManipulator
extends AbstractStringManipulator {
    private static final Character CDATA_CONTROL_CHAR = Character.valueOf(']');
    private static final Character CDATA_CONTROL_FINISH = Character.valueOf('>');
    private static final String CDATA_ENCODED_APPEND = "]]>]]<![CDATA[>";

    CDATAManipulator(CDATAManipulatorOption cdata) {
        super(cdata);
    }

    protected void encodeInternal(String input, Appendable output) throws IOException {
        this.handleString(input, output, false);
    }

    protected void filterInternal(String input, Appendable output) throws IOException {
        this.handleString(input, output, true);
    }

    private void handleString(String input, Appendable output, boolean shouldFilter) throws IOException {
        char[] inputChars = input.toCharArray();
        int inputLength = inputChars.length;
        for (int inputIter = 0; inputIter < inputLength; ++inputIter) {
            char ch = inputChars[inputIter];
            if (ch == CDATA_CONTROL_CHAR.charValue()) {
                int cdataIter = 0;
                char cdataCheck = ch;
                while (cdataCheck == CDATA_CONTROL_CHAR.charValue() && inputLength > inputIter + cdataIter) {
                    cdataCheck = inputChars[inputIter + cdataIter];
                    if (cdataIter > 2) {
                        output.append(CDATA_CONTROL_CHAR.charValue());
                        ++inputIter;
                        continue;
                    }
                    ++cdataIter;
                }
                if (cdataCheck == CDATA_CONTROL_FINISH.charValue() && cdataIter > 2) {
                    if (!shouldFilter) {
                        output.append(CDATA_ENCODED_APPEND);
                    }
                } else {
                    for (int k = 0; k < cdataIter; ++k) {
                        output.append(inputChars[inputIter + k]);
                    }
                }
                inputIter = inputIter + cdataIter - 1;
                continue;
            }
            if (ch <= '\u001f' || ch >= '\u007f' && ch <= '\u0084' || ch >= '\u0086' && ch <= '\u009f' || ch >= '\ufdd0' && ch <= '\ufddf') {
                output.append("");
                continue;
            }
            output.append(ch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CDATAManipulatorOption implements IManipulateOption
    {
        CDATA;

    }
}

