/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation.impl;

import com.demandware.appsec.secure.manipulation.AbstractManipulator;
import com.demandware.appsec.secure.manipulation.impl.CDATAManipulator;
import com.demandware.appsec.secure.manipulation.impl.HTMLManipulator;
import com.demandware.appsec.secure.manipulation.impl.IManipulationType;
import com.demandware.appsec.secure.manipulation.impl.JSONManipulator;
import com.demandware.appsec.secure.manipulation.impl.JavaScriptManipulator;
import com.demandware.appsec.secure.manipulation.impl.URIManipulator;
import com.demandware.appsec.secure.manipulation.impl.XMLManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DefaultManipulationType implements IManipulationType
{
    CDATA_CONTENT_MANIPULATOR(new CDATAManipulator(CDATAManipulator.CDATAManipulatorOption.CDATA)),
    HTML_CONTENT_MANIPULATOR(new HTMLManipulator(HTMLManipulator.HTMLManipulatorOption.CONTENT)),
    HTML_UNQUOTED_ATTRIBUTE_MANIPULATOR(new HTMLManipulator(HTMLManipulator.HTMLManipulatorOption.UNQUOTED_ATTRIBUTE)),
    HTML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR(new HTMLManipulator(HTMLManipulator.HTMLManipulatorOption.SINGLE_QUOTE_ATTRIBUTE)),
    HTML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR(new HTMLManipulator(HTMLManipulator.HTMLManipulatorOption.DOUBLE_QUOTE_ATTRIBUTE)),
    JAVASCRIPT_HTML_MANIPULATOR(new JavaScriptManipulator(JavaScriptManipulator.JavaScriptManipulatorOption.HTML)),
    JAVASCRIPT_ATTRIBUTE_MANIPULATOR(new JavaScriptManipulator(JavaScriptManipulator.JavaScriptManipulatorOption.ATTRIBUTE)),
    JAVASCRIPT_BLOCK_MANIPULATOR(new JavaScriptManipulator(JavaScriptManipulator.JavaScriptManipulatorOption.BLOCK)),
    JAVASCRIPT_SOURCE_MANIPULATOR(new JavaScriptManipulator(JavaScriptManipulator.JavaScriptManipulatorOption.SOURCE)),
    JSON_VALUE_MANIPULATOR(new JSONManipulator(JSONManipulator.JSONManipulatorOption.JSON_VALUE)),
    URI_COMPONENT_MANIPULATOR(new URIManipulator(URIManipulator.URIManipulatorOption.COMPONENT)),
    URI_STRICT_COMPONENT_MANIPULATOR(new URIManipulator(URIManipulator.URIManipulatorOption.COMPONENT_STRICT)),
    XML_CONTENT_MANIPULATOR(new XMLManipulator(XMLManipulator.XMLManipulatorOption.CONTENT)),
    XML_SINGLE_QUOTE_ATTRIBUTE_MANIPULATOR(new XMLManipulator(XMLManipulator.XMLManipulatorOption.SINGLE_QUOTE_ATTRIBUTE)),
    XML_DOUBLE_QUOTE_ATTRIBUTE_MANIPULATOR(new XMLManipulator(XMLManipulator.XMLManipulatorOption.DOUBLE_QUOTE_ATTRIBUTE)),
    XML_COMMENT_MANIPULATOR(new XMLManipulator(XMLManipulator.XMLManipulatorOption.COMMENT_CONTENT));

    private final AbstractManipulator manipulator;

    private DefaultManipulationType(AbstractManipulator manipulator) {
        this.manipulator = manipulator;
    }

    @Override
    public AbstractManipulator getManipulator() {
        return this.manipulator;
    }
}

