/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation.impl;

import com.demandware.appsec.secure.manipulation.AbstractCharacterManipulator;
import com.demandware.appsec.secure.manipulation.IManipulateOption;
import com.demandware.appsec.secure.manipulation.impl.ManipulationUtils;

public class JSONManipulator
extends AbstractCharacterManipulator {
    JSONManipulator(JSONManipulatorOption manipulatorOption) {
        super(manipulatorOption);
    }

    protected String getCorrectCharacter(Character c) {
        String correctedCharacter = "";
        JSONManipulatorOption opt = (JSONManipulatorOption)this.manipulatorOption;
        if (ManipulationUtils.isAlphaNum(c.charValue())) {
            correctedCharacter = String.valueOf(c);
        } else if (ManipulationUtils.isInList(c, opt.getEscapeCharacters())) {
            correctedCharacter = ManipulationUtils.slashEscapeChar(c);
        } else {
            String hex = ManipulationUtils.getHexForCharacter(c.charValue());
            String pad = "0000".substring(hex.length());
            correctedCharacter = "\\u" + pad + hex;
        }
        return correctedCharacter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum JSONManipulatorOption implements IManipulateOption
    {
        JSON_VALUE(Character.valueOf('\b'), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf('\"'), Character.valueOf('\\'), Character.valueOf('/'));

        private final Character[] escape;

        private JSONManipulatorOption(Character ... escape) {
            this.escape = escape;
        }

        public Character[] getEscapeCharacters() {
            return this.escape;
        }
    }
}

