/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation.impl;

import com.demandware.appsec.secure.manipulation.AbstractCharacterManipulator;
import com.demandware.appsec.secure.manipulation.IManipulateOption;
import com.demandware.appsec.secure.manipulation.impl.ManipulationUtils;

public class JavaScriptManipulator
extends AbstractCharacterManipulator {
    JavaScriptManipulator(JavaScriptManipulatorOption manipulatorOption) {
        super(manipulatorOption);
    }

    protected String getCorrectCharacter(Character c) {
        String correctedCharacter = "";
        JavaScriptManipulatorOption opt = (JavaScriptManipulatorOption)this.manipulatorOption;
        if (ManipulationUtils.isAlphaNum(c.charValue())) {
            correctedCharacter = String.valueOf(c);
        } else if (ManipulationUtils.isInList(c, opt.getEscapeCharacters())) {
            correctedCharacter = ManipulationUtils.slashEscapeChar(c);
        } else if (ManipulationUtils.isInList(c, opt.getIgnoreList())) {
            correctedCharacter = String.valueOf(c);
        } else {
            String lead;
            String pad;
            String hex = ManipulationUtils.getHexForCharacter(c.charValue());
            if (c.charValue() < '\u0080') {
                pad = "00".substring(hex.length());
                lead = "\\x";
            } else {
                pad = "0000".substring(hex.length());
                lead = "\\u";
            }
            correctedCharacter = lead + pad + hex;
        }
        return correctedCharacter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum JavaScriptManipulatorOption implements IManipulateOption
    {
        HTML(new Character[]{Character.valueOf('-'), Character.valueOf('/')}, null),
        ATTRIBUTE(new Character[0], null),
        BLOCK(new Character[]{Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('-'), Character.valueOf('/')}, null),
        SOURCE(new Character[]{Character.valueOf('\"'), Character.valueOf('\'')}, new Character[]{Character.valueOf('&')});

        private final Character[] baseEscapeList = new Character[]{Character.valueOf('\b'), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf('\\')};
        private final Character[] baseIgnoreList = new Character[]{Character.valueOf('~'), Character.valueOf('`'), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('_'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('/'), Character.valueOf(' ')};
        private final Character[] escapeList;
        private final Character[] ignoreList;

        private JavaScriptManipulatorOption(Character[] escapes, Character[] ignores) {
            this.escapeList = ManipulationUtils.combineArrays(escapes, this.baseEscapeList);
            this.ignoreList = ManipulationUtils.combineArrays(ignores, this.baseIgnoreList);
        }

        public Character[] getIgnoreList() {
            return this.ignoreList;
        }

        public Character[] getEscapeCharacters() {
            return this.escapeList;
        }
    }
}

