/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation.impl;

public class ManipulationUtils {
    public static Character[] combineArrays(Character[] arr1, Character[] arr2) {
        Character[] join;
        if (arr1 == null && arr2 == null) {
            return null;
        }
        if (arr1 == null) {
            join = (Character[])arr2.clone();
        } else if (arr2 == null) {
            join = (Character[])arr1.clone();
        } else {
            join = new Character[arr1.length + arr2.length];
            System.arraycopy(arr1, 0, join, 0, arr1.length);
            System.arraycopy(arr2, 0, join, arr1.length, arr2.length);
        }
        return join;
    }

    public static final boolean isSame(Character c, String s) {
        return s.length() == 1 && c.equals(Character.valueOf(s.charAt(0)));
    }

    public static final String slashEscapeChar(Character c) {
        String value = null;
        switch (c.charValue()) {
            case '\t': {
                value = "\\t";
                break;
            }
            case '\b': {
                value = "\\b";
                break;
            }
            case '\n': {
                value = "\\n";
                break;
            }
            case '\r': {
                value = "\\r";
                break;
            }
            case '\f': {
                value = "\\f";
                break;
            }
            default: {
                value = "\\" + String.valueOf(c);
            }
        }
        return value;
    }

    public static final boolean isInList(Character c, Character[] list) {
        boolean inList = false;
        if (list == null && c == null) {
            inList = true;
        } else if (list == null || c == null) {
            inList = false;
        } else {
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].equals(c)) continue;
                inList = true;
                break;
            }
        }
        return inList;
    }

    public static final boolean isAlphaNum(char c) {
        return c <= 'z' && c >= 'a' || c <= 'Z' && c >= 'A' || c <= '9' && c >= '0';
    }

    public static final String getHexForCharacter(char c) {
        return Integer.toHexString(c);
    }

    private ManipulationUtils() {
    }
}

