/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation.impl;

import com.demandware.appsec.secure.manipulation.AbstractManipulator;
import com.demandware.appsec.secure.manipulation.impl.DefaultManipulationType;
import com.demandware.appsec.secure.manipulation.impl.IManipulationType;
import java.util.HashMap;
import java.util.Map;

public class ManipulatorFactory {
    private static final ManipulatorFactory instance = new ManipulatorFactory();
    private final Map<IManipulationType, AbstractManipulator> manipulatorMap = new HashMap<IManipulationType, AbstractManipulator>();

    private ManipulatorFactory() {
        for (DefaultManipulationType t : DefaultManipulationType.values()) {
            this.manipulatorMap.put(t, t.getManipulator());
        }
    }

    public static void registerManipulationTypes(IManipulationType ... types) {
        if (types == null) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            IManipulationType type = types[i];
            if (type == null) continue;
            ManipulatorFactory.instance.manipulatorMap.put(type, type.getManipulator());
        }
    }

    public static AbstractManipulator getManipulator(IManipulationType type) {
        if (type == null) {
            throw new IllegalArgumentException("ManipulatorFactory was given an illegal manipulator type");
        }
        return ManipulatorFactory.instance.manipulatorMap.get(type);
    }
}

