/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.secure.manipulation.impl;

import com.demandware.appsec.secure.manipulation.AbstractCharacterManipulator;
import com.demandware.appsec.secure.manipulation.IManipulateOption;
import com.demandware.appsec.secure.manipulation.impl.ManipulationUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLManipulator
extends AbstractCharacterManipulator {
    private static final Map<Character, String> characterToEntityMap = XMLManipulator.createEntityMap();
    private static final String REPLACE_HEX = "";

    static String getReplacementHex() {
        return REPLACE_HEX;
    }

    XMLManipulator(XMLManipulatorOption manipulatorOption) {
        super(manipulatorOption);
    }

    @Override
    protected String getCorrectCharacter(Character c) {
        String entity;
        String correctedCharacter = REPLACE_HEX;
        XMLManipulatorOption opt = (XMLManipulatorOption)this.manipulatorOption;
        correctedCharacter = ManipulationUtils.isAlphaNum(c.charValue()) || ManipulationUtils.isInList(c, opt.getImmuneCharacters()) ? String.valueOf(c) : ((entity = characterToEntityMap.get(c)) != null ? entity : (c.charValue() <= '\u001f' || c.charValue() >= '\u007f' && c.charValue() <= '\u0084' || c.charValue() >= '\u0086' && c.charValue() <= '\u009f' || c.charValue() >= '\ufdd0' && c.charValue() <= '\ufddf' ? REPLACE_HEX : "&#x" + ManipulationUtils.getHexForCharacter(c.charValue()) + ";"));
        return correctedCharacter;
    }

    private static Map<Character, String> createEntityMap() {
        HashMap<Character, String> map = new HashMap<Character, String>(4);
        map.put(Character.valueOf('\"'), "&quot;");
        map.put(Character.valueOf('&'), "&amp;");
        map.put(Character.valueOf('\''), "&apos;");
        map.put(Character.valueOf('<'), "&lt;");
        map.put(Character.valueOf('>'), "&gt;");
        return Collections.unmodifiableMap(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum XMLManipulatorOption implements IManipulateOption
    {
        CONTENT(Character.valueOf('-')),
        SINGLE_QUOTE_ATTRIBUTE(Character.valueOf('-'), Character.valueOf('\"')),
        DOUBLE_QUOTE_ATTRIBUTE(Character.valueOf('-'), Character.valueOf('\'')),
        COMMENT_CONTENT(Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('<'), Character.valueOf('!'), Character.valueOf('>'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('/'), Character.valueOf('='), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('['), Character.valueOf('\\'), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~'));

        private final Character[] baseImmune = new Character[]{Character.valueOf(','), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf(' '), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r')};
        private final Character[] immune;

        private XMLManipulatorOption(Character ... immune) {
            this.immune = ManipulationUtils.combineArrays(immune, this.baseImmune);
        }

        public Character[] getImmuneCharacters() {
            return this.immune;
        }
    }
}

