/*
 * Decompiled with CFR 0.152.
 */
package com.demandware.appsec.csrf;

import com.demandware.appsec.csrf.DefaultCSRFErrorHandler;
import com.demandware.appsec.csrf.ICSRFErrorHandler;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class StatelessCSRFTokenManager {
    public static final long DEFAULT_EXPIRY = 1800000L;
    public static final String DEFAULT_CSRF_TOKEN_NAME = "csrf_token";
    private static final int TOKEN_SIZE = 16;
    private static final int KEY_SIZE = 16;
    private static final int GCM_TAG_BITS = 128;
    private static final int PARAMETER_SPEC_SIZE = 16;
    private static final String SEPARATOR = "|";
    private SecureRandom random;
    private String csrfTokenName;
    private long expiry;
    private ICSRFErrorHandler handler;

    public StatelessCSRFTokenManager() {
        this(null, null);
    }

    public StatelessCSRFTokenManager(SecureRandom random) {
        this(random, null);
    }

    public StatelessCSRFTokenManager(SecureRandom random, ICSRFErrorHandler handler) {
        if (random == null) {
            random = new SecureRandom();
        }
        this.random = random;
        if (handler == null) {
            handler = new DefaultCSRFErrorHandler();
        }
        this.handler = handler;
        this.csrfTokenName = DEFAULT_CSRF_TOKEN_NAME;
        this.expiry = 1800000L;
    }

    public void setErrorHandler(ICSRFErrorHandler handler) throws IllegalArgumentException {
        if (handler == null) {
            throw new IllegalArgumentException("Provided handler is null");
        }
        this.handler = handler;
    }

    public String getCSRFTokenName() {
        return this.csrfTokenName;
    }

    public void setCSRFTokenName(String tokenName) throws IllegalArgumentException {
        if (tokenName == null) {
            throw new IllegalArgumentException("Provided CSRF Token name is null");
        }
        this.csrfTokenName = tokenName;
    }

    public long getAllowedExpiry() {
        return this.expiry;
    }

    public void setAllowedExpiry(long expiry) throws IllegalArgumentException {
        if (expiry < 0L) {
            throw new IllegalArgumentException("Provided token expiration is negative");
        }
        this.expiry = expiry;
    }

    public String generateToken(String sessionID, String ... otherData) throws IllegalArgumentException {
        if (sessionID == null) {
            throw new IllegalArgumentException("Token cannot be generated from null sessionID");
        }
        if (sessionID.length() < 16) {
            this.handler.handleInternalError("Token cannot be generated from session size less than 16");
            return null;
        }
        byte[] tokenId = this.generateID(16);
        byte[] token = this.generateTokenInternal(tokenId, sessionID, otherData);
        byte[] finalBytes = new byte[tokenId.length + token.length];
        System.arraycopy(tokenId, 0, finalBytes, 0, tokenId.length);
        System.arraycopy(token, 0, finalBytes, tokenId.length, token.length);
        String finalToken = this.encodeToken(finalBytes);
        return finalToken;
    }

    private byte[] generateID(int size) {
        byte[] bytes = new byte[size];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private byte[] generateTokenInternal(byte[] id, String sessionID, String ... dataToCrypt) {
        String timestamp = Long.toString(this.getCurrentTime());
        StringBuilder sbCryptText = new StringBuilder();
        sbCryptText.append(sessionID).append(SEPARATOR).append(timestamp);
        if (dataToCrypt != null) {
            int len = dataToCrypt.length;
            for (int i = 0; i < len; ++i) {
                sbCryptText.append(SEPARATOR).append(dataToCrypt[i]);
            }
        }
        String cryptText = sbCryptText.toString();
        byte[] key = sessionID.getBytes(Charset.defaultCharset());
        byte[] iv = id;
        byte[] encryptedValue = null;
        try {
            encryptedValue = this.crypt(key, iv, cryptText.getBytes("UTF-8"), 1);
        }
        catch (Exception e) {
            String error = "CSRF Token generation failed for tokenID " + id + ", and sessionID " + sessionID + " with exception";
            this.handler.handleFatalException(error, e);
        }
        return encryptedValue;
    }

    public boolean validateToken(String token, String sessionID, String ... otherData) throws IllegalArgumentException {
        if (token == null) {
            this.handler.handleInternalError("CSRF token does not exist");
            return false;
        }
        if (sessionID == null) {
            throw new IllegalArgumentException("Provided session id is null");
        }
        boolean isValid = this.validateTokenInternal(token, sessionID, otherData);
        if (!isValid) {
            this.handler.handleValidationError("Could not validate CSRF token. CSRF attack detected");
        }
        return isValid;
    }

    private boolean validateTokenInternal(String token, String sessionID, String ... dataToCrypt) {
        boolean result;
        block8: {
            result = false;
            long timestamp = this.getCurrentTime();
            try {
                int cryptlen;
                byte[] key = sessionID.getBytes(Charset.defaultCharset());
                byte[] tokenByte = this.decodeToken(token);
                byte[] iv = Arrays.copyOfRange(tokenByte, 0, 16);
                byte[] encryptedValue = Arrays.copyOfRange(tokenByte, 16, tokenByte.length);
                byte[] decrypted = this.crypt(key, iv, encryptedValue, 2);
                String cryptText = new String(decrypted, "UTF-8");
                String[] decryptParts = cryptText.split(Pattern.quote(SEPARATOR));
                int n = cryptlen = dataToCrypt == null ? 0 : dataToCrypt.length;
                if (decryptParts.length != 2 + cryptlen) break block8;
                String decryptedSession = decryptParts[0];
                long decryptedTimestamp = Long.parseLong(decryptParts[1]);
                if (!decryptedSession.equals(sessionID)) {
                    String error = "CSRF Token session ids don't match. Expected: " + sessionID + "but received: " + decryptedSession;
                    this.handler.handleValidationError(error);
                    break block8;
                }
                if (decryptedTimestamp + this.getAllowedExpiry() < timestamp) {
                    String error = "CSRF Token has expired. Expected: " + timestamp + " but received: " + decryptedTimestamp;
                    this.handler.handleValidationError(error);
                    break block8;
                }
                if (cryptlen > 0) {
                    for (int i = 0; i < cryptlen; ++i) {
                        String decryptedData = decryptParts[2 + i];
                        String intendedData = dataToCrypt[i];
                        if (!decryptedData.equals(intendedData)) {
                            String error = "CSRF Token data does not match. Excepted: " + intendedData + " but received: " + decryptedData;
                            this.handler.handleValidationError(error);
                            result = false;
                            break block8;
                        }
                        result = true;
                    }
                    break block8;
                }
                result = true;
            }
            catch (AEADBadTagException e) {
                String error = "Could not validate token " + token + " for different session " + sessionID;
                this.handler.handleValidationError(error);
            }
            catch (Exception e) {
                String error = "Could not validate token " + token + " for session " + sessionID + " due to exception: " + e.getMessage();
                this.handler.handleFatalException(error, e);
            }
        }
        return result;
    }

    private byte[] crypt(byte[] key, byte[] iv, byte[] textBytes, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] cryptedValue = null;
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec keyspec = new SecretKeySpec(key, 0, 16, "AES");
        GCMParameterSpec gcmspec = new GCMParameterSpec(128, iv, 0, 16);
        cipher.init(mode, (Key)keyspec, gcmspec);
        cryptedValue = cipher.doFinal(textBytes);
        return cryptedValue;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    protected String encodeToken(byte[] tokenBytes) {
        return Base64.encodeBase64URLSafeString((byte[])tokenBytes);
    }

    protected byte[] decodeToken(String tokenString) {
        return Base64.decodeBase64((String)tokenString);
    }
}

