package com.deque.axe.android

import com.deque.axe.android.conf.IssueFilterConf
import com.deque.axe.android.conf.RuleConf
import com.deque.axe.android.constants.AxeStandard
import com.deque.axe.android.constants.Constants

class AxeConf constructor(
    /**
     * A Set of AxeTypes to include in this AxeRun.
     */
    @JvmField @AxeStandard val standards: MutableSet<String>,
    @JvmField val rules: MutableMap<String, RuleConf> = HashMap(),
    @JvmField val issueFilterConf: IssueFilterConf = IssueFilterConf(),
    @JvmField @Transient val customRules: MutableSet<Class<out AxeRule>> = mutableSetOf()
) {

    companion object {
        /**
         * The default standards to apply to every new Axe Instance.
         */
        @AxeStandard
        private val DEFAULT_STANDARDS: MutableSet<String> = HashSet()

        init {
            DEFAULT_STANDARDS.add(AxeStandard.BEST_PRACTICE)
            DEFAULT_STANDARDS.add(AxeStandard.PLATFORM)
            DEFAULT_STANDARDS.add(AxeStandard.WCAG_20)
            DEFAULT_STANDARDS.add(AxeStandard.WCAG_21)
        }
    }

    constructor() : this(
        standards = DEFAULT_STANDARDS,
        rules = HashMap(),
        issueFilterConf = IssueFilterConf(),
        customRules = HashSet()
    )

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AxeConf

        if (standards != other.standards) return false
        if (rules != other.rules) return false
        if (issueFilterConf != other.issueFilterConf) return false
        if (customRules != other.customRules) return false

        return true
    }

    override fun hashCode(): Int {
        var result = standards.hashCode()
        result = 31 * result + rules.hashCode()
        result = 31 * result + issueFilterConf.hashCode()
        result = 31 * result + customRules.hashCode()
        return result
    }
}