package com.deque.axe.android

import com.deque.axe.android.colorcontrast.AxeImage
import com.deque.axe.android.constants.Constants

/**
 * Manages global state for a set of tests relating back to one particular test run.
 */
class AxeContext internal constructor(
    @JvmField val axeView: AxeView,
    @JvmField val axeDevice: AxeDevice? = null,
    @JvmField val screenshot: AxeImage?,
    @JvmField val axeMetaData: AxeMetaData? = null
) {
    constructor(
        axeView: AxeView,
        axeDevice: AxeDevice?,
        screenshot: AxeImage?,
    ) : this(
        axeView, axeDevice, screenshot, AxeMetaData(
            axeView.appIdentifier(),
            axeView.screenTitle,
            System.currentTimeMillis()
        )
    )

    constructor(
        axeView: AxeView,
        axeDevice: AxeDevice?,
        screenshot: AxeImage?,
        screenTitle: String?
    ) : this(
        axeView, axeDevice, screenshot, AxeMetaData(
            axeView.appIdentifier(),
            screenTitle ?: Constants.DEFAULT_SCREEN_TITLE,
            System.currentTimeMillis()
        )
    )

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AxeContext

        if (axeView != other.axeView) return false
        if (axeDevice != other.axeDevice) return false
        if (screenshot != other.screenshot) return false
        if (axeMetaData != other.axeMetaData) return false

        return true
    }

    override fun hashCode(): Int {
        var result = axeView.hashCode()
        result = 31 * result + axeDevice.hashCode()
        result = 31 * result + (screenshot?.hashCode() ?: 0)
        result = 31 * result + axeMetaData.hashCode()
        return result
    }
}