package com.deque.axe.android;

import java.util.Objects;

public class AxeDevice {

    public final float dpi;

    public final String name;

    public final String os;

    public final String osVersion;

    public final int screenHeight;

    public final int screenWidth;

    /**
     * A collection of information useful for identifying a particular device.
     * @param dpi Pixel Density of the device.
     * @param name The common name of the device.
     * @param osVersion The OS Version installed on the device.
     * @param screenHeight The height in pixels of the device.
     * @param screenWidth The width in pixels of the device.
     */
    public AxeDevice(
            final float dpi,
            final String name,
            final String osVersion,
            final int screenHeight,
            final int screenWidth
    ) {
        this.dpi = dpi;
        this.name = name;
        this.os = "Android";
        this.osVersion = "Android " + osVersion;
        this.screenHeight = screenHeight;
        this.screenWidth = screenWidth;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AxeDevice axeDevice = (AxeDevice) o;

        if (Float.compare(axeDevice.dpi, dpi) != 0) {
            return false;
        }
        if (screenHeight != axeDevice.screenHeight) {
            return false;
        }
        if (screenWidth != axeDevice.screenWidth) {
            return false;
        }
        if (!Objects.equals(name, axeDevice.name)) {
            return false;
        }
        if (!Objects.equals(os, axeDevice.os)) {
            return false;
        }
        return Objects.equals(osVersion, axeDevice.osVersion);
    }

    @Override
    public int hashCode() {
        int result = (dpi != +0.0f ? Float.floatToIntBits(dpi) : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + os.hashCode();
        result = 31 * result + osVersion.hashCode();
        result = 31 * result + screenHeight;
        result = 31 * result + screenWidth;
        return result;
    }
}
