package com.deque.axe.android

import com.deque.axe.android.constants.Config.AXE_VERSION
import com.deque.axe.android.constants.Constants
import java.util.*

/**
 * Build an AxeMetaData object.
 * @param appIdentifier The identifier of the application. (PackageName for Android)
 * @param screenTitle A reasonably unique identifier for the current screen. (Default provided)
 * @param timestamp The date the analysis was performed.
 */
class AxeMetaData private constructor(
    @JvmField val appIdentifier: String?,
    @JvmField val screenTitle: String?,
    @JvmField val analysisTimestamp: Long?,
    @JvmField val axeVersion: String?,
) {
    constructor(
        appIdentifier: String?,
        screenTitle: String? = Constants.DEFAULT_SCREEN_TITLE,
        analysisTimestamp: Long?
    ) : this(
        appIdentifier,
        screenTitle,
        analysisTimestamp,
        AXE_VERSION
    )

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AxeMetaData

        if (appIdentifier != other.appIdentifier) return false
        if (screenTitle != other.screenTitle) return false
        if (analysisTimestamp != other.analysisTimestamp) return false
        if (axeVersion != other.axeVersion) return false

        return true
    }

    override fun hashCode(): Int {
        var result = appIdentifier?.hashCode() ?: 0
        result = 31 * result + screenTitle.hashCode()
        result = 31 * result + analysisTimestamp.hashCode()
        result = 31 * result + axeVersion.hashCode()
        return result
    }
}