package com.deque.axe.android

import com.deque.axe.android.constants.AxeStatus
import java.util.LinkedList

open class AxeResult @JvmOverloads constructor(
    @JvmField val axeConf: AxeConf?,
    @JvmField val axeContext: AxeContext?,
    @JvmField val axeRuleResults: MutableList<AxeRuleResult>? = LinkedList(),
    @JvmField var scanName: String? = "",
    @JvmField var tags: Set<String>? = setOf()
) {
    fun add(axeRuleResult: AxeRuleResult) {
        if (axeRuleResult.status != AxeStatus.INAPPLICABLE) {
            axeRuleResults?.add(axeRuleResult)
        }
    }

    /**
     * Query the list of Rule Results for a particular subset of results.
     * @param filter The matcher to filter on.
     * @return The list of results that match the filter.
     */
    fun query(filter: AxeRuleResult.Matcher): List<AxeRuleResult> {

        // Micro optimization. Init with size / 2. Results will always be larger than the filtered set.
        val results = ArrayList<AxeRuleResult>(
            axeRuleResults?.let { it.size / 2 } ?: 0
        )
        axeRuleResults?.let {
            for (ruleResult in axeRuleResults) {
                if (filter.matches(ruleResult)) {
                    results.add(ruleResult)
                }
            }
        }
        return results
    }
}
