package com.deque.axe.android;

import com.deque.axe.android.conf.RuleConf;
import com.deque.axe.android.constants.AndroidClassNames;
import com.deque.axe.android.constants.AxeStandard;

/**
 * Main AxeRule class.
 */
public abstract class AxeRule {

  public final String id;

  public final int impact;

  public final @AxeStandard String standard;

  public final String summary;

  public final boolean experimental;

  public AxeRule(final RuleConf ruleConf) {
    this.id = getClass().getSimpleName();
    this.impact = ruleConf.impact;
    this.summary = ruleConf.summary;
    this.standard = ruleConf.standard;
    this.experimental = ruleConf.experimental;
  }

  public boolean classNameIsOfType(
          String fullClassName,
          @AndroidClassNames String viewClass
  ){
    return viewClass.equalsIgnoreCase(fullClassName);
  }
}
