package com.deque.axe.android.conf

import com.deque.axe.android.utils.SuppressFBWarnings

@SuppressFBWarnings(
    value = ["URF_UNREAD_FIELD"], justification = "This is an object that isn't used for"
            + " anything but serialization."
)
class IssueFilterConf {
    @JvmField
    var onlyShowResultsVisibleToUser = false

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IssueFilterConf

        if (onlyShowResultsVisibleToUser != other.onlyShowResultsVisibleToUser) return false

        return true
    }

    override fun hashCode(): Int {
        return onlyShowResultsVisibleToUser.hashCode()
    }

}

