package com.deque.axe.android.constants


object Config {
    var AXE_VERSION = "0.0"
    val UNDER_TEST: Boolean
        get() {
            val isCoreTest = isClassInTest("com.deque.axe.android.AxeTest")
            val isAxeDevToolsAndroidTest = isClassInTest("com.deque.mobile.devtools.AxeDevToolsViewBuilderTest")
            return isCoreTest || isAxeDevToolsAndroidTest
        }

    private fun isClassInTest(className: String): Boolean {
        return try {
            Class.forName(className)
            true
        } catch (e: ClassNotFoundException) {
            false
        }
    }
}