package com.deque.axe.android.moshi

import com.deque.networking.models.auth.AccessTokenResponse
import com.squareup.moshi.FromJson
import com.squareup.moshi.ToJson

/**
 * TODO : Find a way to auto-generate this adapter
 * https://app.zenhub.com/workspaces/mobile---android-618c52b298700300142de56d/issues/dequelabs/axe-devtools-android/398
 * This is necessary because ProGuard strips the @Json(name = "") annotation
 */
internal class AccessTokenResponseAdapter {
    @ToJson
    fun toJson(accessTokenResponse: AccessTokenResponse): TokenResponseJson {
        return TokenResponseJson(
            accessTokenResponse.accessTokenValue,
            accessTokenResponse.expiresIn,
            accessTokenResponse.refreshExpiresIn,
            accessTokenResponse.refreshToken,
            accessTokenResponse.tokenType
        )
    }

    @FromJson
    fun fromJson(tokenResponseJson: TokenResponseJson): AccessTokenResponse {
        return AccessTokenResponse(
            tokenResponseJson.access_token,
            tokenResponseJson.expires_in,
            tokenResponseJson.refresh_expires_in,
            tokenResponseJson.refresh_token,
            tokenResponseJson.token_type
        )
    }
}

internal data class TokenResponseJson(
    val access_token: String?,
    val expires_in: Int = 0,
    val refresh_expires_in: Int = 0,
    val refresh_token: String,
    val token_type: String?
)