package com.deque.axe.android.moshi

import com.deque.axe.android.AxeConf
import com.deque.axe.android.AxeContext
import com.deque.axe.android.AxeDevice
import com.deque.axe.android.AxeMetaData
import com.deque.axe.android.AxeResult
import com.deque.axe.android.AxeRuleResult
import com.deque.axe.android.colorcontrast.AxeColor
import com.deque.axe.android.colorcontrast.AxeImage
import com.deque.axe.android.conf.IssueFilterConf
import com.deque.axe.android.conf.RuleConf
import com.deque.axe.android.wrappers.AxeProps
import com.deque.axe.android.wrappers.AxeRect
import com.squareup.moshi.FromJson
import com.squareup.moshi.ToJson


internal class AxeResultAdapter {
    @FromJson
    fun fromJson(axeResultJson: AxeResultJSON): AxeResult {
        return AxeResult(
            axeResultJson.axeConf?.toAxeConf(),
            axeResultJson.axeContext?.toAxeContext(),
            axeResultJson.toAxeRuleResult()?.toMutableList(),
            axeResultJson.scanName,
            axeResultJson.tags
        )
    }

    @ToJson
    fun toJson(axeResult: AxeResult): AxeResultJSON {
        return AxeResultJSON(axeResult)
    }

    private fun AxeResultJSON.toAxeRuleResult() =
        axeRuleResults?.map { axeRuleResultJSON ->
            AxeRuleResult(
                axeRuleResultJSON.ruleId,
                axeRuleResultJSON.ruleSummary,
                axeRuleResultJSON.axeViewId,
                axeRuleResultJSON.status,
                axeRuleResultJSON.impact,
                AxeProps().apply { axeRuleResultJSON.props?.let { putAll(it) } },
                axeRuleResultJSON.isVisibleToUser
            )
        }

    private fun AxeContextJSON.toAxeContext() = AxeContext(
        this.axeView.toLocalModel(),
        axeDevice?.let { device ->
            AxeDevice(
                device.dpi,
                device.name,
                device.osVersion,
                device.screenHeight,
                device.screenWidth
            )
        },
        object : AxeImage() {
            override fun frame(): AxeRect = AxeRect(0, 0, 0, 0)
            override fun pixel(x: Int, y: Int): AxeColor = AxeColor("")
            override fun toBase64Png(): String? = screenshot
        },
        axeMetaData?.let { AxeMetaData(it.appIdentifier, it.screenTitle, it.analysisTimestamp) }
    )

    private fun AxeConfJSON.toAxeConf() = AxeConf(
        this.standards.toMutableSet(),
        rules = this.rules.mapValues { entry ->
            RuleConf(entry.value.impact, entry.value.standard, entry.value.summary, entry.value.experimental == true)
        }.toMutableMap(),
        issueFilterConf = IssueFilterConf().apply {
            this.onlyShowResultsVisibleToUser =
                this@toAxeConf.issueFilterConf.onlyShowResultsVisibleToUser
        },
        customRules = this.customRules.toMutableSet()
    )

}