package com.deque.axe.android.moshi

import com.deque.axe.android.AxeView
import com.deque.axe.android.CalculatedProps
import com.deque.axe.android.colorcontrast.AxeColor
import com.deque.axe.android.wrappers.AxeRect
import com.deque.axe.android.wrappers.TextBoundsInScreen
import com.squareup.moshi.FromJson
import com.squareup.moshi.ToJson


internal class AxeViewAdapter {

    @FromJson
    fun fromJson(axeViewJson: AxeViewJSON): AxeView {
        return axeViewJson.toLocalModel()
    }

    @ToJson
    fun toJson(axeView: AxeView): AxeViewJSON {
        return AxeViewJSON(axeView)
    }
}

internal fun AxeViewJSON.toLocalModel(): AxeView {
    return object : AxeView.Builder {
        override fun boundsInScreen(): AxeRect {
            return boundsInScreen.let {
                AxeRect(it.left, it.right, it.top, it.bottom)
            }
        }
        override fun className(): String? = className
        override fun contentDescription(): String? = contentDescription
        override fun isAccessibilityFocusable(): Boolean = isAccessibilityFocusable
        override fun isFocusable(): Boolean = isFocusable
        override fun isClickable(): Boolean = isClickable
        override fun isEnabled(): Boolean = isEnabled
        override fun isImportantForAccessibility(): Boolean = isImportantForAccessibility
        override fun labeledBy(): AxeView? = labeledBy?.toLocalModel()
        override fun packageName(): String? = packageName
        override fun paneTitle(): String? = paneTitle
        override fun text(): String? = text
        override fun viewIdResourceName(): String? = viewIdResourceName
        override fun hintText(): String? = hintText
        override fun value(): String? = value
        override fun children(): List<AxeView> = children.map { it.toLocalModel() }
        override fun overridesAccessibilityDelegate(): Boolean = overridesAccessibilityDelegate
        override fun isVisibleToUser(): Boolean = isVisibleToUser
        override fun visibility(): Int = visibility
        override fun measuredHeight(): Int = measuredHeight
        override fun measuredWidth(): Int = measuredWidth
        override fun textColor(): AxeColor?  = textColor
        override fun id(): Int = id
        override fun isLongClickable(): Boolean = isLongClickable
        override fun isComposeView(): Boolean = isComposeView
        override fun ignoreRules(): Set<String> = ignoreRules
        override fun mlKitIdentifiedTextAndBoundsInScreen(): List<TextBoundsInScreen> = mlKitIdentifiedTextAndBoundsInScreen
        override fun screenOrientation(): Int? = screenOrientation
        override fun calculatedProps(): CalculatedProps = calculatedProps
        override fun screenTitle(): String? = screenTitle
        override fun activityClassName(): String? = activityClassName
        override fun appLabel(): String? = appLabel
        override fun fragmentClassNames(): List<String>? = fragmentClassNames
        override fun isRootView(): Boolean = isRootView

    }.build()
}