package com.deque.axe.android.moshi

import com.deque.axe.android.utils.SuppressFBWarnings
import com.squareup.moshi.Moshi
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory

object MoshiConfig {

    private val extraAdapters = mutableSetOf<Any>()
    val axeMoshiConfig get() = AxeMoshiConfig(extraAdapters)

    fun <T> prettyPrint(uglyPrint: T, clazz: Class<T>): String {
        return AxeMoshiConfig(extraAdapters).moshi.adapter(clazz).indent("  ").toJson(uglyPrint)
    }

    @SuppressFBWarnings
    fun addAdapters(adapterSet: Set<Any>) {
        extraAdapters.addAll(adapterSet)
    }
}

class AxeMoshiConfig(additionalAdapters: Set<Any> = setOf()) {
    val moshi: Moshi get() = _moshi
    private var _moshi = getMoshiInstance(additionalAdapters)

    private fun getMoshiInstance(additionalAdapters: Set<Any>): Moshi {
        val builder = Moshi.Builder()
        additionalAdapters.forEach { builder.add(it) }
        builder
            .add(AxeColorAdapter())
            .add(AxeViewAdapter())
            .add(AxeResultAdapter())
            .add(AxePropsAdapter())
            .add(AccessTokenResponseAdapter())
            .addLast(KotlinJsonAdapterFactory())
        return builder.build()
    }
}