package com.deque.axe.android.utils

object AxeTextUtils {
    fun isNullOrEmpty(string: String?): Boolean {
        return string == null || string.trim { it <= ' ' }.isEmpty()
    }

    fun String.containsTextElement(text: String, ignoreCase: Boolean = false): Boolean {
        return this.isNotEmpty()
                && this.padStartEndWithSpace().contains(text.padStartEndWithSpace(), ignoreCase = ignoreCase)
    }

    fun String.padStartEndWithSpace(): String = this.padStart(1).padEnd(1)

    fun String.hasSpecialCharacters(): Boolean = this.contains("[\$&+=\\\\@#|/<>^*()%!]".toRegex())

    fun CharSequence.clean(): CharSequence {
        val packageNameAndClassNameRegEx = Regex("""(?:([a-zA-Z_${'$'}][a-zA-Z\d_${'$'}]*(?:\.[a-zA-Z_${'$'}][a-zA-Z\d_${'$'}]*)*)\.)?(.*)""")
        val title = packageNameAndClassNameRegEx.find(this)?.groupValues?.get(2)
        return if (title.isNullOrEmpty()) this else title
    }

    fun charSequenceToString(charSequence: CharSequence?): String? {
        if (charSequence == null) {
            return null
        }
        return (charSequence.toString())
    }
}