package com.deque.axe.android.wrappers

/**
 * AxePoint a representation of coordinates on screen.
 * @param x The x value or column.
 * @param y The y value or row.
 */
class AxePoint(val valueX: Int, val valueY: Int) {
    fun isTrailingEdge(frame: AxeRect): Boolean {
        return frame.isTrailingEdge(this)
    }

    fun isLeadingEdge(frame: AxeRect): Boolean {
        return frame.isLeadingEdge(this)
    }

    override fun toString(): String {
        return "Row: $valueY Col: $valueX"
    }
}