package com.deque.axe.android.wrappers

import androidx.annotation.StringDef

class AxeProps : HashMap<String, Any?>() {

    @Retention(AnnotationRetention.SOURCE)
    @StringDef(Name.CLASS_NAME, Name.CONTENT_DESCRIPTION, Name.DPI, Name.FRAME, Name.HEIGHT_DP,
        Name.IMPORTANT, Name.IS_CLICKABLE, Name.IS_ENABLED, Name.LABELED_BY, Name.SPEAKABLE_TEXT,
        Name.WIDTH_DP, Name.EXCEPTION, Name.STACK_TRACE, Name.EVENT_STREAM, Name.IS_FOCUS_CHANGE_OK,
        Name.IS_TOUCH_EXPLORATION_GESTURE, Name.IS_TOUCH_STARTED, Name.ACCESSIBILITY_EVENT,
        Name.VISIBLE_TEXT, Name.COLOR_BACKGROUND, Name.COLOR_FOREGROUND, Name.COLOR_CONTRAST,
        Name.CONFIDENCE, Name.CONTENT_DESCRIPTION_RECURSIVE, Name.SCREEN_HEIGHT, Name.SCREEN_WIDTH, Name.IS_OFF_SCREEN, Name.IS_RENDERED,
        Name.IS_PARTIALLY_VISIBLE, Name.HINT_TEXT, Name.OVERRIDES_ACCESSIBILITY_DELEGATE,
        Name.LABELED_BY_VIEW_OVERRIDES_ACCESSIBILITY_DELEGATE, Name.IS_VISIBLE_TO_USER, Name.VISIBILITY,
        Name.MEASURED_HEIGHT, Name.MEASURED_WIDTH, Name.IGNORED_RULES_LIST, Name.AXE_VIEW_ID, Name.IS_COMPOSE_VIEW,
        Name.VIEW_ID, Name.CLICKABLE_SIBLING_COUNT, Name.TOTAL_SIBLING_COUNT, Name.IS_PARENT_CLICKABLE,
        Name.ARE_ALL_CLICKABLE_SIBLINGS_NOT_IMPORTANT_FOR_ACCESSIBILITY, Name.IS_PARENT_NULL, Name.IS_FOCUSABLE,
        Name.PARENT_CONTENT_DESCRIPTION, Name.IS_TEXT_ELEMENT, Name.IS_PARENT_ACCESSIBLE, Name.ML_CALCULATED_TEXT_FRAME,
        Name.ML_CALCULATED_TEXT, Name.HAS_CHILDREN, Name.HAS_ML_TEXT, Name.CONTAINS_INVISIBLE_CHILD_WITH_TEXT,
        Name.CONTAINS_CHILD_WITH_IMAGE, Name.IS_COMPOUND_COMPOSABLE, Name.UNMERGED_SEMANTICS_NODE_TEXT,
        Name.SCREEN_ORIENTATION, Name.SCREEN_TITLE, Name.IS_ROOT_VIEW, Name.APP_LABEL, Name.PACKAGE_NAME,
        Name.ACTIVITY_CLASS_NAME, Name.FRAGMENT_CLASS_NAMES, Name.ANNOTATED_STRING_TEXT_SIZE, Name.HAS_INVISIBLE_TO_USER_PROP
    )
    annotation class Name {
        companion object {
            const val CLASS_NAME = "className"
            const val CONTENT_DESCRIPTION = "contentDescription"
            const val PARENT_CONTENT_DESCRIPTION = "parentContentDescription"
            const val DPI = "Screen Dots Per Inch"
            const val FRAME = "boundsInScreen"
            const val HEIGHT_DP = "height - density pixels"
            const val IMPORTANT = "isImportantForAccessibility"
            const val IS_CLICKABLE = "isActive"
            const val IS_ENABLED = "isEnabled"
            const val LABELED_BY = "labeledBy"
            const val SPEAKABLE_TEXT = "Speakable Text"
            const val WIDTH_DP = "width - density pixels"
            const val EXCEPTION = "Exception"
            const val STACK_TRACE = "Stack Trace"
            const val EVENT_STREAM = "Applicable Event Stream"
            const val ACCESSIBILITY_EVENT = "AccessibilityEvent"
            const val IS_TOUCH_STARTED = "Touch Interaction Started"
            const val IS_FOCUS_CHANGE_OK = "Is Focus Change Acceptable"
            const val IS_TOUCH_EXPLORATION_GESTURE = "Touch Exploration Started"
            const val VISIBLE_TEXT = "Visible Text"
            const val COLOR_FOREGROUND = "Foreground Color"
            const val COLOR_BACKGROUND = "Background Color"
            const val COLOR_CONTRAST = "Color Contrast Ratio"
            const val CONFIDENCE = "Confidence in Color Detection"
            const val CONTENT_DESCRIPTION_RECURSIVE = "Content Description Recursive"
            const val SCREEN_HEIGHT = "Screen Height"
            const val SCREEN_WIDTH = "Screen Width"
            const val IS_RENDERED = "isRendered"
            const val IS_OFF_SCREEN = "isOffScreen"
            const val IS_PARTIALLY_VISIBLE = "isPartiallyVisible"
            const val HINT_TEXT = "Hint Text"
            const val OVERRIDES_ACCESSIBILITY_DELEGATE = "overridesAccessibilityDelegate"
            const val LABELED_BY_VIEW_OVERRIDES_ACCESSIBILITY_DELEGATE =
                "labeledByViewOverridesAccessibilityDelegate"
            const val IS_VISIBLE_TO_USER = "isVisibleToUser"
            const val VISIBILITY = "visibility"
            const val MEASURED_HEIGHT = "measuredHeight"
            const val MEASURED_WIDTH = "measuredWidth"
            const val IS_COMPOSE_VIEW = "isComposeView"
            const val IGNORED_RULES_LIST = "ignoredRulesList"
            const val AXE_VIEW_ID = "axeViewId"
            const val VIEW_ID = "viewId"
            const val ARE_ALL_CLICKABLE_SIBLINGS_NOT_IMPORTANT_FOR_ACCESSIBILITY = "areAllClickableSiblingsNotImportantForAccessibility"
            const val IS_PARENT_CLICKABLE = "isParentClickable"
            const val CLICKABLE_SIBLING_COUNT = "numberOfClickableSiblings"
            const val TOTAL_SIBLING_COUNT = "totalNumberOfSiblings"
            const val IS_PARENT_NULL = "isParentNull"
            const val IS_FOCUSABLE = "isFocusable"
            const val IS_TEXT_ELEMENT = "isTextElement"
            const val IS_PARENT_ACCESSIBLE = "isParentAccessible"
            const val ML_CALCULATED_TEXT_FRAME = "ML Calculated Text BoundsInScreen"
            const val ML_CALCULATED_TEXT = "ML Calculated Text"
            const val HAS_CHILDREN = "hasChildren"
            const val HAS_ML_TEXT = "hasMlText"
            const val SCREEN_ORIENTATION = "Screen Orientation"
            const val CONTAINS_INVISIBLE_CHILD_WITH_TEXT = "containsInvisibleChildWithText"
            const val CONTAINS_CHILD_WITH_IMAGE = "containsChildWithImage"
            const val IS_COMPOUND_COMPOSABLE = "isCompoundComposable"
            const val UNMERGED_SEMANTICS_NODE_TEXT = "unMergedSemanticsNodeText"
            const val SCREEN_TITLE = "Screen Title"
            const val IS_ROOT_VIEW = "isRootView"
            const val APP_LABEL = "Application Label"
            const val PACKAGE_NAME = "Package Name"
            const val ACTIVITY_CLASS_NAME = "Activity Class Name"
            const val FRAGMENT_CLASS_NAMES = "Fragment Class Names"
            const val ANNOTATED_STRING_TEXT_SIZE = "Annotated String Text Size"
            const val HAS_INVISIBLE_TO_USER_PROP = "Has Invisible To User Prop"
        }
    }

    operator fun <T> get(name: String?, clazz: Class<T>): T {
        return clazz.cast(get(name))
    }

    override fun put(key: String, value: Any?): Any? {
        if (value is Throwable) throw RuntimeException("Could not put value in props with key: $key, reason: ${value.localizedMessage}")
        return super.put(key, value)
    }

    override fun putAll(from: Map<out String, Any?>) {
        from.forEach {
            if (it.value is Throwable) throw RuntimeException("Could not put value in props with key: ${it.key}, reason: ${(it.value as Throwable).localizedMessage}")
        }
        super.putAll(from)
    }

    override fun putIfAbsent(key: String, value: Any?): Any? {
        if (value is Throwable) throw RuntimeException("Could not put value in props with key: $key, reason: ${value.localizedMessage}")
        return super.putIfAbsent(key, value)
    }
}