package com.deque.networking.interfaces.data

import java.util.*

class TagsSet() : TreeSet<String>() {
    constructor(delimitedTags: String?) : this() {
        addAll(delimitedTags)
    }

    override fun add(element: String): Boolean {
        val tagTrimmed = element.trim { it <= ' ' }
        if (tagTrimmed.isEmpty()) {
            return false
        }
        if (tagTrimmed.contains(DELIMITER)) {
            System.err.println("Axe DevTools Android: Adding a tag including this demlimiter: '$DELIMITER' would split the tag into more tags.")
            addAll(tagTrimmed)
            return true
        }
        return super.add(element.trim { it <= ' ' })
    }

    /**
     * Add all tags from a delimited string.
     * @param delimitedTags The delimited string.
     * @return The number of tags added.
     */
    fun addAll(delimitedTags: String?): Int {
        return if (delimitedTags == null) {
            0
        } else {
            addAll(delimitedTags.trim { it <= ' ' }.split(DELIMITER).toTypedArray())
        }
    }

    /**
     * Add all tags from an array of strings.
     * @param tags Array of Strings.
     * @return The number of tags added.
     */
    fun addAll(tags: Array<String>?): Int {
        return if (tags == null) {
            0
        } else {
            for (s in tags) {
                add(s)
            }
            tags.size
        }
    }

    /**
     * Add all tags from another TagsSet.
     * @param tagsSet The other TagsSet.
     * @return True if the set changed.
     */
    fun addAll(tagsSet: TagsSet?): Boolean {
        return if (tagsSet != null) {
            super.addAll(tagsSet)
        } else {
            false
        }
    }

    override fun toString(): String {
        val result = StringBuilder()
        forEach { s: String? ->
            if (result.isNotEmpty()) {
                result.append(DELIMITER)
            }
            result.append(s)
        }
        return result.toString()
    }

    companion object {
        private const val DELIMITER = "::"
        @JvmStatic
        operator fun get(tag: String?): TagsSet {
            return TagsSet(tag)
        }
    }
}