package com.deque.networking.models

import com.deque.axe.android.moshi.MoshiConfig
import com.deque.networking.utils.GzipRequestInterceptor
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.moshi.MoshiConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory

const val DEFAULT_CONTENT_TYPE = "Content-Type: application/json"

open class DequeRetrofitBuilder(url: String, private val interceptor: Interceptor? = null) {
    private val retrofitBuilder: Retrofit.Builder

    //un-comment for internal use.
//    fun debug(): DequeRetrofitBuilder {
//        return debug(HttpLoggingInterceptor.Level.HEADERS)
//    }
//
//    fun debug(level: HttpLoggingInterceptor.Level): DequeRetrofitBuilder {
//        val logging = HttpLoggingInterceptor()
//        logging.level = level
//        val httpClient = OkHttpClient.Builder()
//        httpClient.addInterceptor(logging)
//        httpClient.readTimeout(2, TimeUnit.MINUTES)
//        httpClient.callTimeout(2, TimeUnit.MINUTES)
//        retrofitBuilder.client(httpClient.build())
//        return this
//    }

    open fun url(url: String): DequeRetrofitBuilder {
        retrofitBuilder.baseUrl(url)
        return this
    }

    fun <T> client(clazz: Class<T>): T {
        return retrofitBuilder.build().create(clazz)
    }

    fun okHttpBuilder(): DequeRetrofitBuilder {
        val httpClient = OkHttpClient.Builder()
        httpClient.addInterceptor(GzipRequestInterceptor())
        interceptor?.let { httpClient.addInterceptor(it) }
        retrofitBuilder.client(httpClient.build())
        return this
    }

    init {
        retrofitBuilder = Retrofit.Builder()
            .baseUrl(url)
            .addConverterFactory(
                ScalarsConverterFactory.create()
            )
            .addConverterFactory(
                MoshiConverterFactory.create(MoshiConfig.axeMoshiConfig.moshi)
            )
            .addCallAdapterFactory(ResultCallAdapterFactory())

    }
}