package com.deque.networking.models.devtools

import com.deque.axe.android.AxeResult
import com.deque.networking.models.DEFAULT_CONTENT_TYPE
import com.deque.networking.models.devtools.serializable.AxeDevToolsResultKey
import com.deque.networking.models.devtools.serializable.AxeDevToolsResultSummaryResponse
import com.deque.networking.models.devtools.serializable.UserInfo
import retrofit2.http.Body
import retrofit2.http.DELETE
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Headers
import retrofit2.http.POST
import retrofit2.http.PUT
import retrofit2.http.Path
import retrofit2.http.Query

interface AxeDevToolsApiKeyInterface {

    @POST("/attest/result/axe")
    @Headers(DEFAULT_CONTENT_TYPE)
    suspend fun uploadResult(
        @Header("X-Api-Key") key: String?,
        @Body axeResult: AxeResult
    ): Result<AxeDevToolsResultKey>

    @POST("/attest/result/axe")
    @Headers(DEFAULT_CONTENT_TYPE)
    suspend fun uploadResult(@Body axeResult: AxeResult?): Result<AxeDevToolsResultKey>


    @DELETE("/attest/result/{userId}/{packageName}/{resultId}")
    @Headers(DEFAULT_CONTENT_TYPE)
    suspend fun deleteResult(
        @Header("X-Api-Key") key: String?,
        @Path("userId") userId: String,
        @Path("packageName") packageName: String,
        @Path("resultId") resultId: String
    ): Result<Unit>

    @GET("/attest/result/axe/{userId}/{packageName}/{resultId}")
    @Headers(DEFAULT_CONTENT_TYPE)
    suspend fun getAxeDevToolsResultAxe(
        @Header("X-Api-Key") key: String?,
        @Path("userId") userId: String,
        @Path("packageName") packageName: String,
        @Path("resultId") resultId: String
    ): Result<com.deque.networking.models.devtools.serializable.AxeResult>

    @POST("/attest/result/tag/{userId}/{packageName}/{resultId}")
    @Headers(DEFAULT_CONTENT_TYPE)
    suspend fun postAxeDevToolsResultTag(
        @Header("X-Api-Key") key: String?,
        @Path("userId") userId: String,
        @Path("packageName") packageName: String,
        @Path("resultId") resultId: String,
        @Body tags: TagsSet?
    ): Result<AxeDevToolsResultKey>

    @GET("/attest/results/summaries")
    @Headers(DEFAULT_CONTENT_TYPE)
    suspend fun getSummariesByUser(
        @Header("X-Api-Key") key: String?,
        @Query("user") user: String,
    ): Result<AxeDevToolsResultSummaryList>

    @PUT("/attest/results/summaries/{userId}/{packageName}/{resultId}/name")
    @Headers("Content-Type: text/plain")
    suspend fun setScanName(
        @Header("X-Api-Key") key: String?,
        @Path("userId") userId: String,
        @Path("packageName") packageName: String,
        @Path("resultId") resultId: String,
        @Body scanName: String
    ): Result<AxeDevToolsResultSummaryResponse>

    @GET("/attest/user")
    suspend fun getUserInfo(@Header("X-Api-Key") key: String?): Result<UserInfo>
}