package com.deque.networking.models.devtools.serializable

import com.deque.axe.android.constants.AxeStandard

data class AxeConf(
    /**
     * A Set of AxeTypes to include in this AxeRun.
     */
    @JvmField @AxeStandard val standards: Set<String> = setOf(),
    /**
     * A set of AxeRules that will be included Regardless of any other setting.
     */
    @JvmField val ruleIds: Set<String> = setOf(),
    @JvmField val rules: Map<String, RuleConf> = mapOf(),
    @JvmField val issueFilterConf: IssueFilterConf = IssueFilterConf(false),
    @JvmField @Transient val customRules: Set<Class<out AxeRule>> = setOf()
)