package com.deque.networking.models.devtools.serializable;

import com.deque.networking.AxeLogger;

public class AxeDevToolsResultKey implements Comparable<AxeDevToolsResultKey> {

  @SuppressWarnings("WeakerAccess")
  public final String userId;

  @SuppressWarnings("WeakerAccess")
  public final String packageName;

  @SuppressWarnings("WeakerAccess")
  public final String resultId;

  @SuppressWarnings("WeakerAccess")
  public static AxeDevToolsResultKey fromPath(final String path) {
    return fromPath(path.split("/"));
  }

  /**
   * Create an AxeDevToolsResultKey from a URL path relating to it.
   * @param pathElements The path for the key. Should look like: "userId/packageName/resultId".
   * @return A new AxeDevToolsResultKey object or blank AxeDevToolsResultKey object if pathElements don't have length of 3.
   */
  public static AxeDevToolsResultKey fromPath(final String[] pathElements) {
    if (pathElements.length != 3) {
      AxeLogger.Companion.fromPathRequiresThreeElements(pathElements);
      return new AxeDevToolsResultKey("", "", "");
    } else {
      return new AxeDevToolsResultKey(pathElements[0], pathElements[1], pathElements[2]);
    }
  }

  /**
   * Construct an AxeDevToolsResultKey.
   * @param userId The userId that owns the result.
   * @param packageName The package the result came from.
   * @param resultId The id of the result.
   */
  public AxeDevToolsResultKey(
      final String userId,
      final String packageName,
      final String resultId
  ) {
    this.userId = userId;
    this.packageName = packageName;
    this.resultId = resultId;
  }

  public String toPath() {
    return userId + "/" + packageName + "/" + resultId;
  }

  public Boolean isValid() { return !userId.isEmpty() && !packageName.isEmpty() && !resultId.isEmpty(); }

  @Override
  public String toString() {
    return toPath();
  }

  @Override
  public boolean equals(Object object) {

    if (object == this) {
      return true;
    }

    if (!(object instanceof AxeDevToolsResultKey)) {
      return false;
    }

    final AxeDevToolsResultKey otherKey = (AxeDevToolsResultKey) object;

    return compareTo(otherKey) == 0;

  }

  @Override
  public int hashCode() {
    return toString().hashCode();
  }

  @Override
  public int compareTo(AxeDevToolsResultKey o) {
    return toString().compareTo(o.toString());
  }
}
