package com.deque.networking.models.devtools.serializable

import com.deque.axe.android.constants.AxeStatus
import com.deque.networking.models.devtools.AxeProps

data class AxeRuleResult(
    /**
     * The ID of the rule that generated the result. Very often also the ClassName of the Rule.
     */
    @JvmField val ruleId: String?,
    /**
     * The basic description of the Rule that failed.
     */
    @JvmField val ruleSummary: String?,
    /**
     * A unique identifier for an AxeView within a given set of axeRuleResults.
     */
    @JvmField val axeViewId: String?,
    /**
     * One of [PASS, FAIL, INCOMPLETE, INAPPLICABLE].
     */
    @JvmField @AxeStatus val status: String?,
    /**
     * The impact of the rule [0=MINOR, 1=MODERATE, 2=SERIOUS, 3=CRITICAL, 4=BLOCKER].
     */
    @JvmField var impact: Int,
    /**
     * The properties used in determining that the AxeView was in violation.
     */
    @JvmField val props: AxeProps?,
    /**
     * True if the view is visible to the user.
     */
    @JvmField val isVisibleToUser: Boolean
)
